/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsAutoSpacing;
import org.apache.myfaces.tobago.component.SupportsHelp;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public abstract class MessageLayoutRendererBase<T extends UIComponent & SupportsAutoSpacing>
extends LabelLayoutRendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        if (this.isInside(facesContext, HtmlElements.COMMAND)) {
            this.encodeBeginField(facesContext, component);
        } else {
            super.encodeBeginInternal(facesContext, component);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        if (this.isInside(facesContext, HtmlElements.COMMAND)) {
            this.encodeEndField(facesContext, component);
        } else {
            super.encodeEndInternal(facesContext, component);
        }
    }

    @Override
    public void encodeBeginMessageField(FacesContext facesContext, T component) throws IOException {
        this.encodeBeginMessagesContainer(facesContext, component);
        this.encodeBeginField(facesContext, component);
    }

    @Override
    public void encodeEndMessageField(FacesContext facesContext, T component) throws IOException {
        this.encodeEndField(facesContext, component);
        this.encodeEndMessagesContainer(facesContext, component);
    }

    private void encodeBeginMessagesContainer(FacesContext facesContext, T component) throws IOException {
        boolean hasHelp;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId();
        List messages = facesContext.getMessageList(clientId);
        String help = component instanceof SupportsHelp ? ((SupportsHelp)component).getHelp() : null;
        boolean hasMessage = !messages.isEmpty();
        boolean bl = hasHelp = !StringUtils.isEmpty(help);
        if (hasMessage || hasHelp) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.MESSAGES__CONTAINER);
        }
    }

    private void encodeEndMessagesContainer(FacesContext facesContext, T component) throws IOException {
        boolean hasHelp;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId();
        List messages = facesContext.getMessageList(clientId);
        String help = component instanceof SupportsHelp ? ((SupportsHelp)component).getHelp() : null;
        boolean hasMessage = !messages.isEmpty();
        boolean bl = hasHelp = !StringUtils.isEmpty(help);
        if (hasMessage || hasHelp) {
            Integer tabIndex;
            Integer n = tabIndex = component instanceof AbstractUIInput ? ((AbstractUIInput)component).getTabIndex() : null;
            if (hasMessage) {
                this.encodePopover(writer, BootstrapClass.buttonColor(ComponentUtils.getMaximumSeverity(messages)), Icons.EXCLAMATION_LG, this.getTitle(messages), this.getMessage(messages), tabIndex);
            }
            if (hasHelp) {
                this.encodePopover(writer, BootstrapClass.BTN_OUTLINE_INFO, Icons.QUESTION_LG, ResourceUtils.getString(facesContext, "help.title"), help, tabIndex);
            }
            writer.endElement(HtmlElements.DIV);
        }
    }

    protected abstract void encodeBeginField(FacesContext var1, T var2) throws IOException;

    protected abstract void encodeEndField(FacesContext var1, T var2) throws IOException;

    private String getTitle(List<FacesMessage> messages) {
        int fatalCount = 0;
        int errorCount = 0;
        int warningCount = 0;
        int informationCount = 0;
        for (FacesMessage message : messages) {
            if (FacesMessage.SEVERITY_FATAL.equals(message.getSeverity())) {
                ++fatalCount;
                continue;
            }
            if (FacesMessage.SEVERITY_ERROR.equals(message.getSeverity())) {
                ++errorCount;
                continue;
            }
            if (FacesMessage.SEVERITY_WARN.equals(message.getSeverity())) {
                ++warningCount;
                continue;
            }
            if (!FacesMessage.SEVERITY_INFO.equals(message.getSeverity())) continue;
            ++informationCount;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (messages.size() > 1) {
            if (fatalCount > 0) {
                stringBuilder.append(fatalCount);
                stringBuilder.append(" Fatal");
                if (errorCount + warningCount + informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (errorCount > 0) {
                stringBuilder.append(errorCount);
                stringBuilder.append(" Error");
                if (errorCount > 1) {
                    stringBuilder.append("s");
                }
                if (warningCount + informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (warningCount > 0) {
                stringBuilder.append(warningCount);
                stringBuilder.append(" Warning");
                if (warningCount > 1) {
                    stringBuilder.append("s");
                }
                if (informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (informationCount > 0) {
                stringBuilder.append(informationCount);
                stringBuilder.append(" Information");
            }
        } else if (fatalCount == 1) {
            stringBuilder.append("Fatal");
        } else if (errorCount == 1) {
            stringBuilder.append("Error");
        } else if (warningCount == 1) {
            stringBuilder.append("Warning");
        } else if (informationCount == 1) {
            stringBuilder.append("Information");
        }
        return stringBuilder.toString();
    }

    private String getMessage(List<FacesMessage> messages) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean firstMessage = true;
        for (FacesMessage message : messages) {
            if (firstMessage) {
                firstMessage = false;
            } else {
                stringBuilder.append("\n\n");
            }
            stringBuilder.append(message.getDetail());
        }
        return stringBuilder.toString();
    }

    private void encodePopover(TobagoResponseWriter writer, CssItem buttonColor, Icons icon, String title, String content, Integer tabIndex) throws IOException {
        writer.startElement(HtmlElements.TOBAGO_POPOVER);
        writer.writeAttribute(DataAttributes.BS_TOGGLE, "popover", false);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute(DataAttributes.BS_CONTENT, content, true);
        writer.writeAttribute(DataAttributes.BS_TRIGGER, "focus", false);
        writer.startElement(HtmlElements.A);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, tabIndex != null ? tabIndex : 0);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROLE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.BTN, buttonColor);
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(icon);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.A);
        writer.endElement(HtmlElements.TOBAGO_POPOVER);
    }
}

