/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.sanitizer;

import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.apache.myfaces.tobago.exception.TobagoConfigurationException;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupSanitizer
implements Sanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Whitelist whitelist;
    private String whitelistName;
    private boolean unmodifiable = false;

    @Override
    public String sanitize(String html) {
        String safe = Jsoup.clean((String)html, (Whitelist)this.whitelist);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sanitized: " + safe);
        }
        return safe;
    }

    @Override
    public void setProperties(Properties configuration) {
        this.checkLocked();
        this.unmodifiable = true;
        for (String key : configuration.stringPropertyNames()) {
            if ("whitelist".equals(key)) {
                this.whitelistName = configuration.getProperty(key);
                if ("basic".equals(this.whitelistName)) {
                    this.whitelist = Whitelist.basic();
                    continue;
                }
                if ("basicWithImages".equals(this.whitelistName)) {
                    this.whitelist = Whitelist.basicWithImages();
                    continue;
                }
                if ("none".equals(this.whitelistName)) {
                    this.whitelist = Whitelist.none();
                    continue;
                }
                if ("relaxed".equals(this.whitelistName)) {
                    this.whitelist = Whitelist.relaxed();
                    continue;
                }
                if ("simpleText".equals(this.whitelistName)) {
                    this.whitelist = Whitelist.simpleText();
                    continue;
                }
                throw new TobagoConfigurationException("Unknown configuration value for 'whitelist' in tobago-config.xml found! value='" + this.whitelistName + "'");
            }
            throw new TobagoConfigurationException("Unknown configuration key in tobago-config.xml found! key='" + key + "'");
        }
        if (LOG.isInfoEnabled()) {
            LOG.warn("Using whitelist '" + this.whitelistName + "' for sanitizing!");
        }
    }

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new TobagoConfigurationException("The configuration must not be changed after initialization!");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " whitelist='" + this.whitelistName + "'";
    }
}

