/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlRendererUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private HtmlRendererUtils() {
    }

    public static String getRendererName(FacesContext facesContext, UIComponent component) {
        String rendererType = component.getRendererType();
        return rendererType.substring(0, 1).toLowerCase(Locale.ENGLISH) + rendererType.substring(1);
    }

    public static void writeLabelWithAccessKey(TobagoResponseWriter writer, LabelWithAccessKey label) throws IOException {
        int pos = label.getPos();
        String text = label.getLabel();
        if (text != null) {
            if (pos == -1) {
                writer.writeText(text);
            } else {
                writer.writeText(text.substring(0, pos));
                writer.startElement(HtmlElements.U);
                writer.writeText(Character.toString(text.charAt(pos)));
                writer.endElement(HtmlElements.U);
                writer.writeText(text.substring(pos + 1));
            }
        }
    }

    public static void encodeIconOrImage(TobagoResponseWriter writer, String image) throws IOException {
        if (image != null) {
            if (Icons.matches(image)) {
                writer.startElement(HtmlElements.I);
                writer.writeClassAttribute(Icons.custom(image));
                writer.endElement(HtmlElements.I);
            } else {
                writer.startElement(HtmlElements.IMG);
                writer.writeAttribute(HtmlAttributes.SRC, image, true);
                writer.writeAttribute(HtmlAttributes.ALT, "", false);
                writer.endElement(HtmlElements.IMG);
            }
        }
    }

    public static String getTitleFromTipAndMessages(FacesContext facesContext, UIComponent component) {
        String messages = ComponentUtils.getFacesMessageAsString(facesContext, component);
        return HtmlRendererUtils.addTip(messages, ComponentUtils.getAttribute(component, Attributes.tip));
    }

    public static String addTip(String title, Object tip) {
        String result = title;
        if (tip != null) {
            result = result != null && result.length() > 0 ? result + " :: " : "";
            result = result + tip;
        }
        return result;
    }

    @Deprecated
    public static void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, String[] submittedValues, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        HtmlRendererUtils.renderSelectItems(component, optionClass, items, values, submittedValues, null, writer, facesContext);
    }

    @Deprecated
    public static void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object value, String submittedValue, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        String[] stringArray;
        Object[] objectArray;
        if (value != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        } else {
            objectArray = null;
        }
        if (submittedValue != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = submittedValue;
        } else {
            stringArray = null;
        }
        HtmlRendererUtils.renderSelectItems(component, optionClass, items, objectArray, stringArray, null, writer, facesContext);
    }

    @Deprecated
    public static void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, String[] submittedValues, Boolean onlySelected, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        new RendererBase<UIComponent>(){

            public void fake(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, String[] submittedValues, Boolean onlySelected, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
                this.renderSelectItems(component, optionClass, items, values, submittedValues, onlySelected, writer, facesContext);
            }
        }.fake(component, optionClass, items, values, submittedValues, onlySelected, writer, facesContext);
    }

    public static void writeDataAttributes(FacesContext context, TobagoResponseWriter writer, UIComponent component) throws IOException {
        Map<Object, Object> dataAttributes = ComponentUtils.getDataAttributes(component);
        if (dataAttributes == null) {
            return;
        }
        ELContext elContext = context.getELContext();
        for (Map.Entry<Object, Object> entry : dataAttributes.entrySet()) {
            Object mapKey = entry.getKey();
            String name = mapKey instanceof ValueExpression ? ((ValueExpression)mapKey).getValue(elContext).toString() : mapKey.toString();
            Object mapValue = entry.getValue();
            String value = mapValue instanceof ValueExpression ? ((ValueExpression)mapValue).getValue(elContext).toString() : mapValue.toString();
            writer.writeAttribute(DataAttributes.dynamic(name), value, true);
        }
    }
}

