/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyCheckbox;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectReference;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectManyRendererBase;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyCheckboxRenderer<T extends AbstractUISelectManyCheckbox>
extends SelectManyRendererBase<T> {
    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_SELECT_MANY_CHECKBOX;
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        AbstractUISelectReference reference = ((AbstractUISelectManyCheckbox)component).getRenderRangeReference();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String id = component.getClientId(facesContext);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        boolean disabled = ((AbstractUISelectManyCheckbox)component).isDisabled();
        boolean readonly = ((AbstractUISelectManyCheckbox)component).isReadonly();
        boolean required = component.isRequired();
        boolean inline = ((AbstractUISelectManyCheckbox)component).isInline();
        Markup markup = component.getMarkup();
        boolean isInsideCommand = this.isInside(facesContext, HtmlElements.COMMAND);
        writer.startElement(HtmlElements.TOBAGO_SELECT_MANY_CHECKBOX);
        writer.writeClassAttribute(inline ? BootstrapClass.FORM_CHECK_INLINE : null, component.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        boolean first = true;
        Object[] values = ((AbstractUISelectManyBase)component).getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)component);
        int i = 0;
        int[] renderRange = this.getRenderRangeList((AbstractUISelectManyCheckbox)component, reference);
        for (SelectItem item : SelectItemUtils.getItemIterator(facesContext, component)) {
            if (renderRange == null || ArrayUtils.contains(renderRange, i)) {
                String label;
                org.apache.myfaces.tobago.model.SelectItem tobagoItem;
                String image;
                boolean itemDisabled = item.isDisabled() || disabled;
                String itemId = id + "::" + i;
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(BootstrapClass.FORM_CHECK, inline ? BootstrapClass.FORM_CHECK_INLINE : null, isInsideCommand ? BootstrapClass.DROPDOWN_ITEM : null);
                writer.startElement(HtmlElements.INPUT);
                writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INPUT);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                String formattedValue = this.getFormattedValue(facesContext, component, item.getValue());
                boolean checked = submittedValues == null ? ArrayUtils.contains(values, item.getValue()) : ArrayUtils.contains(submittedValues, formattedValue);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
                writer.writeNameAttribute(id);
                writer.writeIdAttribute(itemId);
                writer.writeAttribute(HtmlAttributes.VALUE, formattedValue, true);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, itemDisabled);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
                if (first) {
                    SelectManyCheckboxRenderer.renderFocus(id, ((AbstractUISelectManyCheckbox)component).isFocus(), ((AbstractUISelectManyBase)component).isError(), facesContext, writer);
                    first = false;
                }
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectManyCheckbox)component).getTabIndex());
                writer.endElement(HtmlElements.INPUT);
                writer.startElement(HtmlElements.LABEL);
                writer.writeClassAttribute(BootstrapClass.FORM_CHECK_LABEL);
                writer.writeAttribute(HtmlAttributes.FOR, itemId, false);
                if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = (tobagoItem = (org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                    writer.startElement(HtmlElements.IMG);
                    writer.writeAttribute(HtmlAttributes.SRC, image, true);
                    writer.writeAttribute(HtmlAttributes.ALT, "", false);
                    writer.endElement(HtmlElements.IMG);
                }
                if ((label = item.getLabel()) != null) {
                    writer.writeText(label);
                }
                writer.endElement(HtmlElements.LABEL);
                writer.endElement(HtmlElements.DIV);
            }
            ++i;
        }
    }

    private int[] getRenderRangeList(AbstractUISelectManyCheckbox select, AbstractUISelectReference reference) {
        int[] indices = StringUtils.getIndices(reference != null ? reference.getRenderRange() : select.getRenderRange());
        return (int[])(indices.length > 0 ? indices : null);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_SELECT_MANY_CHECKBOX);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return component.getClientId(facesContext);
    }
}

