/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectBoolean;
import org.apache.myfaces.tobago.internal.renderkit.renderer.MessageLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SelectBooleanRendererBase<T extends AbstractUISelectBoolean>
extends MessageLayoutRendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUISelectBoolean)component).isDisabled() || ((AbstractUISelectBoolean)component).isReadonly();
    }

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        if (this.isOutputOnly(component)) {
            return;
        }
        String newValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(component.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug("new value = '" + newValue + "'");
        }
        component.setSubmittedValue((Object)("true".equals(newValue) ? "true" : "false"));
        this.decodeClientBehaviors(facesContext, component);
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUISelectBoolean)component).getFieldId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, component);
        boolean checked = "true".equals(currentValue);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        boolean disabled = ((AbstractUISelectBoolean)component).isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)component, true);
        String itemLabel = ((AbstractUISelectBoolean)component).getItemLabel();
        String itemImage = ((AbstractUISelectBoolean)component).getItemImage();
        Markup markup = component.getMarkup();
        boolean insideCommand = this.isInside(facesContext, HtmlElements.COMMAND);
        writer.startElement(insideCommand ? this.getComponentTag() : HtmlElements.DIV);
        if (insideCommand) {
            writer.writeIdAttribute(clientId);
        }
        writer.writeClassAttribute((CssItem)BootstrapClass.FORM_CHECK, this.getOuterCssItems(facesContext, (AbstractUISelectBoolean)component), new CssItem[]{component.getCustomClass()});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.startElement(HtmlElements.INPUT);
        writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
        writer.writeAttribute(HtmlAttributes.VALUE, "true", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, ((AbstractUISelectBoolean)component).isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, component.isRequired());
        SelectBooleanRendererBase.renderFocus(clientId, ((AbstractUISelectBoolean)component).isFocus(), ((AbstractUISelectBoolean)component).isError(), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectBoolean)component).getTabIndex());
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.LABEL);
        writer.writeClassAttribute(BootstrapClass.FORM_CHECK_LABEL);
        if (!disabled && label.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), clientId);
        }
        writer.writeAttribute(HtmlAttributes.FOR, fieldId, false);
        if (itemImage != null) {
            writer.startElement(HtmlElements.IMG);
            writer.writeAttribute(HtmlAttributes.SRC, itemImage, true);
            writer.writeAttribute(HtmlAttributes.ALT, "", false);
            writer.endElement(HtmlElements.IMG);
        }
        if (itemLabel != null && ((AbstractUISelectBoolean)component).getLabel() == null && component.getAccessKey() != null) {
            if (itemLabel.contains(Character.toString(component.getAccessKey().charValue()))) {
                HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            }
        } else if (itemLabel != null) {
            writer.writeText(itemLabel);
        }
        writer.endElement(HtmlElements.LABEL);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        boolean insideCommand = this.isInside(facesContext, HtmlElements.COMMAND);
        writer.endElement(insideCommand ? this.getComponentTag() : HtmlElements.DIV);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    protected abstract CssItem[] getOuterCssItems(FacesContext var1, AbstractUISelectBoolean var2);

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUISelectBoolean)component).getFieldId(facesContext);
    }
}

