/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.RenderRange;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.SupportsAutoSpacing;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecodingInputRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public abstract class LabelLayoutRendererBase<T extends UIComponent & SupportsAutoSpacing>
extends DecodingInputRendererBase<T> {
    public abstract HtmlElements getComponentTag();

    protected CssItem[] getComponentCss(FacesContext facesContext, T command) {
        return null;
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        this.encodeBeginSurroundingLabel(facesContext, component);
        if (!((SupportsLabelLayout)component).isNextToRenderIsLabel()) {
            this.encodeBeginMessageField(facesContext, component);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        if (!((SupportsLabelLayout)component).isNextToRenderIsLabel()) {
            this.encodeEndMessageField(facesContext, component);
        }
        if (component.getRendersChildren()) {
            List<AbstractUIStyle> children = ComponentUtils.findDescendantList(component, AbstractUIStyle.class);
            for (AbstractUIStyle child : children) {
                child.encodeAll(facesContext);
            }
        }
        this.encodeEndSurroundingLabel(facesContext, component);
    }

    @Override
    public void encodeChildrenInternal(FacesContext context, T component) throws IOException {
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                if (!child.isRendered() || child instanceof AbstractUIStyle) continue;
                child.encodeAll(context);
            }
        }
    }

    protected abstract void encodeBeginMessageField(FacesContext var1, T var2) throws IOException;

    protected abstract void encodeEndMessageField(FacesContext var1, T var2) throws IOException;

    protected void encodeBeginSurroundingLabel(FacesContext facesContext, T component) throws IOException {
        boolean flow;
        boolean flex;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component instanceof RenderRange && ((RenderRange)component).getRenderRangeReference() != null ? ((RenderRange)component).getRenderRangeReference().getClientId(facesContext) : component.getClientId(facesContext);
        Markup markup = (Markup)ComponentUtils.getAttribute(component, Attributes.markup);
        boolean autoSpacing = ((SupportsAutoSpacing)component).getAutoSpacing(facesContext);
        LabelLayout labelLayout = ((SupportsLabelLayout)component).getLabelLayout();
        boolean nextToRenderIsLabel = ((SupportsLabelLayout)component).isNextToRenderIsLabel();
        switch (labelLayout) {
            case flexLeft: 
            case flexRight: {
                flex = true;
                break;
            }
            case segmentLeft: 
            case segmentRight: {
                flex = false;
                break;
            }
            case flowLeft: 
            case gridLeft: 
            case gridRight: 
            case gridTop: 
            case gridBottom: {
                this.encodeLabel(facesContext, component, writer, labelLayout);
                flex = false;
                break;
            }
            default: {
                flex = false;
            }
        }
        switch (labelLayout) {
            case flowLeft: 
            case flowRight: {
                flow = true;
                break;
            }
            default: {
                flow = false;
            }
        }
        if (!nextToRenderIsLabel) {
            writer.startElement(this.getComponentTag());
            writer.writeIdAttribute(clientId);
            writer.writeClassAttribute((CssItem)(flex ? TobagoClass.LABEL__CONTAINER : null), this.getComponentCss(facesContext, component), new CssItem[]{autoSpacing ? TobagoClass.AUTO__SPACING : null, ComponentUtils.getBooleanAttribute(component, Attributes.required) ? TobagoClass.REQUIRED : null, flow ? TobagoClass.DISPLAY__INLINE__BLOCK : null, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
            this.writeAdditionalAttributes(facesContext, writer, component);
        }
        switch (labelLayout) {
            case flexRight: 
            case flowLeft: 
            case gridLeft: 
            case gridRight: 
            case gridTop: 
            case gridBottom: 
            case none: 
            case flowRight: {
                break;
            }
            case segmentLeft: 
            case segmentRight: {
                if (!nextToRenderIsLabel) break;
                this.encodeLabel(facesContext, component, writer, labelLayout);
                break;
            }
            default: {
                this.encodeLabel(facesContext, component, writer, labelLayout);
            }
        }
    }

    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, T input) throws IOException {
    }

    protected void encodeEndSurroundingLabel(FacesContext facesContext, T component) throws IOException {
        boolean nextToRenderIsLabel;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        LabelLayout labelLayout = ((SupportsLabelLayout)component).getLabelLayout();
        if (labelLayout == LabelLayout.flexRight) {
            this.encodeLabel(facesContext, component, writer, labelLayout);
        }
        if (!(nextToRenderIsLabel = ((SupportsLabelLayout)component).isNextToRenderIsLabel())) {
            writer.endElement(this.getComponentTag());
        }
        if (labelLayout == LabelLayout.flowRight) {
            this.encodeLabel(facesContext, component, writer, labelLayout);
        }
    }

    protected void encodeLabel(FacesContext facesContext, T component, TobagoResponseWriter writer, LabelLayout labelLayout) throws IOException {
        String label = ComponentUtils.getStringAttribute(component, Attributes.label);
        if (StringUtils.isNotBlank(label)) {
            writer.startElement(HtmlElements.LABEL);
            if (labelLayout == LabelLayout.gridLeft || labelLayout == LabelLayout.gridRight || labelLayout == LabelLayout.gridTop || labelLayout == LabelLayout.gridBottom) {
                String clientId = component instanceof RenderRange && ((RenderRange)component).getRenderRangeReference() != null ? ((RenderRange)component).getRenderRangeReference().getClientId(facesContext) : component.getClientId(facesContext);
                String labelId = clientId + "::" + "label";
                writer.writeIdAttribute(labelId);
            }
            writer.writeAttribute(HtmlAttributes.FOR, this.getFieldId(facesContext, component), false);
            writer.writeClassAttribute(BootstrapClass.COL_FORM_LABEL);
            if (component instanceof SupportsAccessKey) {
                LabelWithAccessKey labelWithAccessKey = new LabelWithAccessKey((SupportsAccessKey)component);
                HtmlRendererUtils.writeLabelWithAccessKey(writer, labelWithAccessKey);
            } else {
                writer.writeText(label);
            }
            writer.endElement(HtmlElements.LABEL);
        }
    }

    protected abstract String getFieldId(FacesContext var1, T var2);
}

