/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.exception.TobagoConfigurationException;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.sanitizer.IgnoringSanitizer;
import org.apache.myfaces.tobago.sanitizer.JsoupSanitizer;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoConfigMerger {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<TobagoConfigFragment> fragments;
    private final TobagoConfig tobagoConfig;

    private TobagoConfigMerger(List<TobagoConfigFragment> fragments, TobagoConfig tobagoConfig) {
        this.fragments = fragments;
        this.tobagoConfig = tobagoConfig;
    }

    public static void merge(List<TobagoConfigFragment> fragments, TobagoConfig tobagoConfig) {
        TobagoConfigMerger merger = new TobagoConfigMerger(fragments, tobagoConfig);
        merger.merge();
        merger.resolveThemes();
    }

    private void merge() {
        String sanitizerClass = JsoupSanitizer.class.getName();
        Properties sanitizerProperties = new Properties();
        sanitizerProperties.setProperty("whitelist", "relaxed");
        for (TobagoConfigFragment fragment : this.fragments) {
            String defaultTheme = fragment.getDefaultThemeName();
            if (defaultTheme != null) {
                this.tobagoConfig.setDefaultThemeName(defaultTheme);
            }
            for (String supported : fragment.getSupportedThemeNames()) {
                this.tobagoConfig.addSupportedThemeName(supported);
            }
            if (fragment.getCreateSessionSecret() != null) {
                this.tobagoConfig.setCreateSessionSecret(fragment.getCreateSessionSecret());
            }
            if (fragment.getCheckSessionSecret() != null) {
                this.tobagoConfig.setCheckSessionSecret(fragment.getCheckSessionSecret());
            }
            if (fragment.getPreventFrameAttacks() != null) {
                this.tobagoConfig.setPreventFrameAttacks(fragment.getPreventFrameAttacks());
            }
            if (fragment.getContentSecurityPolicy() != null) {
                this.tobagoConfig.getContentSecurityPolicy().merge(fragment.getContentSecurityPolicy());
            }
            if (fragment.getSecurityAnnotation() != null) {
                this.tobagoConfig.setSecurityAnnotation(fragment.getSecurityAnnotation());
            }
            if (fragment.getSetNosniffHeader() != null) {
                this.tobagoConfig.setSetNosniffHeader(fragment.getSetNosniffHeader());
            }
            if (fragment.getSanitizerClass() != null) {
                sanitizerClass = fragment.getSanitizerClass();
                sanitizerProperties = fragment.getSanitizerProperties();
            }
            if (fragment.getDecodeLineFeed() != null) {
                this.tobagoConfig.setDecodeLineFeed(fragment.getDecodeLineFeed());
            }
            if (fragment.getEnableTobagoExceptionHandler() != null) {
                this.tobagoConfig.setEnableTobagoExceptionHandler(fragment.getEnableTobagoExceptionHandler());
            }
            for (ThemeImpl theme : fragment.getThemeDefinitions()) {
                this.tobagoConfig.addAvailableTheme(theme);
            }
            Map<String, String> mimeTypes = this.tobagoConfig.getMimeTypes();
            for (Map.Entry<String, String> entry : fragment.getMimeTypes().entrySet()) {
                mimeTypes.put(entry.getKey(), entry.getValue());
            }
        }
        this.resolveThemes(this.tobagoConfig.getAvailableThemes());
        if (sanitizerClass != null) {
            try {
                Class<Sanitizer> aClass = Class.forName(sanitizerClass).asSubclass(Sanitizer.class);
                Sanitizer sanitizer = aClass.newInstance();
                sanitizer.setProperties(sanitizerProperties);
                this.tobagoConfig.setSanitizer(sanitizer);
            }
            catch (Exception e) {
                LOG.error("Can't create sanitizer: '" + sanitizerClass + "'", (Throwable)e);
                this.tobagoConfig.setSanitizer(new IgnoringSanitizer());
            }
        }
    }

    private void resolveThemes(Map<String, ThemeImpl> map) {
        for (ThemeImpl theme : map.values()) {
            String fallbackName = theme.getFallbackName();
            ThemeImpl fallback = map.get(fallbackName);
            theme.setFallback(fallback);
        }
        for (ThemeImpl theme : map.values()) {
            theme.resolveFallbacks();
        }
        for (ThemeImpl theme : map.values()) {
            theme.resolveResources();
        }
        for (ThemeImpl theme : map.values()) {
            theme.init();
        }
    }

    private void resolveThemes() {
        Theme defaultTheme;
        Map<String, ThemeImpl> availableThemes = this.tobagoConfig.getAvailableThemes();
        if (this.tobagoConfig.getDefaultThemeName() != null) {
            String defaultThemeName = this.tobagoConfig.getDefaultThemeName();
            defaultTheme = availableThemes.get(defaultThemeName);
            this.tobagoConfig.setDefaultTheme(defaultTheme);
            this.checkThemeIsAvailable(defaultThemeName, defaultTheme, availableThemes);
            if (LOG.isDebugEnabled()) {
                LOG.debug("name = '{}'", (Object)defaultThemeName);
                LOG.debug("defaultTheme = '{}'", (Object)defaultTheme);
            }
        } else {
            int deep = 0;
            defaultTheme = null;
            for (Map.Entry<String, ThemeImpl> entry : availableThemes.entrySet()) {
                Theme theme = entry.getValue();
                if (theme.getFallbackList().size() <= deep) continue;
                defaultTheme = theme;
                deep = theme.getFallbackList().size();
            }
            if (defaultTheme == null) {
                String error = "Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your classpath. Usually tobago-theme-standard.jar in WEB-INF/lib";
                LOG.error("Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your classpath. Usually tobago-theme-standard.jar in WEB-INF/lib");
                throw new TobagoConfigurationException("Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your classpath. Usually tobago-theme-standard.jar in WEB-INF/lib");
            }
            this.tobagoConfig.setDefaultTheme(defaultTheme);
            if (LOG.isInfoEnabled()) {
                LOG.info("Using default Theme {}", (Object)defaultTheme.getName());
            }
        }
        if (!this.tobagoConfig.getSupportedThemeNames().isEmpty()) {
            for (String name : this.tobagoConfig.getSupportedThemeNames()) {
                Theme theme = availableThemes.get(name);
                this.checkThemeIsAvailable(name, theme, availableThemes);
                this.tobagoConfig.getSupportedThemes().add(theme);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("name = '{}'", (Object)name);
                LOG.debug("last added theme = '{}'", (Object)theme);
            }
        }
    }

    private void checkThemeIsAvailable(String name, Theme theme, Map<String, ThemeImpl> availableThemes) {
        if (theme == null) {
            String error = "Theme not found! name: '" + name + "'. Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Found the following themes: " + availableThemes.keySet();
            LOG.error(error);
            throw new TobagoConfigurationException(error);
        }
    }
}

