/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.enterprise.context.RequestScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.util.CookieUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@RequestScoped
public class TobagoContext
implements Serializable {
    public static final String BEAN_NAME = "tobagoContext";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TobagoConfig tobagoConfig;
    private Theme theme;
    private UserAgent userAgent;
    private String focusId;
    private String enctype;

    @Deprecated
    public ResourceBundle getResourceBundle() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        return ResourceBundle.getBundle("tobagoResourceBundle", locale);
    }

    @Deprecated
    public ResourceBundle getMessageBundle() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        return ResourceBundle.getBundle("org.apache.myfaces.tobago.context.TobagoMessage", locale);
    }

    public TobagoConfig getTobagoConfig() {
        if (this.tobagoConfig == null) {
            this.tobagoConfig = TobagoConfig.getInstance(FacesContext.getCurrentInstance());
        }
        return this.tobagoConfig;
    }

    public Theme getTheme() {
        if (this.theme == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            Object request = externalContext.getRequest();
            String themeName = request instanceof HttpServletRequest ? CookieUtils.getThemeNameFromCookie((HttpServletRequest)request) : null;
            this.theme = this.getTobagoConfig().getTheme(themeName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("theme='{}'", (Object)this.theme.getName());
            }
        }
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public UserAgent getUserAgent() {
        if (this.userAgent == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            String requestUserAgent = (String)externalContext.getRequestHeaderMap().get("User-Agent");
            this.userAgent = UserAgent.getInstance(requestUserAgent);
            if (LOG.isDebugEnabled()) {
                LOG.debug("userAgent='" + this.userAgent + "' from header 'User-Agent: " + requestUserAgent + "'");
            }
        }
        return this.userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public static TobagoContext getInstance(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (requestMap.containsKey(BEAN_NAME)) {
            return (TobagoContext)requestMap.get(BEAN_NAME);
        }
        TobagoContext tobagoContext = new TobagoContext();
        requestMap.put(BEAN_NAME, tobagoContext);
        return tobagoContext;
    }
}

