/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.internal.behavior.EventBehavior;
import org.apache.myfaces.tobago.internal.component.AbstractUIEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.internal.component.AbstractUITab;
import org.apache.myfaces.tobago.internal.component.AbstractUITabGroup;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.SwitchType;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class TabGroupRenderer
extends RendererBase
implements ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(TabGroupRenderer.class);
    private static final String ACTIVE_INDEX_POSTFIX = "::activeIndex";

    public void processEvent(ComponentSystemEvent event) {
        AbstractUITabGroup tabGroup = (AbstractUITabGroup)event.getComponent();
        block6: for (UIComponent child : tabGroup.getChildren()) {
            if (!(child instanceof AbstractUITab)) continue;
            AbstractUITab tab = (AbstractUITab)child;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ClientBehaviors click = ClientBehaviors.click;
            switch (tabGroup.getSwitchType()) {
                case none: {
                    continue block6;
                }
                case client: {
                    continue block6;
                }
                case reloadTab: {
                    AjaxBehavior ajaxBehavior = new AjaxBehavior();
                    Set<String> ids = Collections.singleton(UINamingContainer.getSeparatorChar((FacesContext)facesContext) + tabGroup.getClientId(facesContext));
                    ajaxBehavior.setExecute(ids);
                    ajaxBehavior.setRender(ids);
                    tab.addClientBehavior(click.name(), (ClientBehavior)ajaxBehavior);
                    continue block6;
                }
                case reloadPage: {
                    AbstractUIEvent component = (AbstractUIEvent)ComponentUtils.createComponent(facesContext, Tags.event.componentType(), RendererTypes.Event, "_click");
                    component.setEvent(click);
                    tab.getChildren().add(component);
                    EventBehavior eventBehavior = new EventBehavior();
                    eventBehavior.setFor(component.getId());
                    tab.addClientBehavior(click.name(), (ClientBehavior)eventBehavior);
                    continue block6;
                }
            }
            LOG.error("Unknown switch type: '{}'", (Object)tabGroup.getSwitchType());
        }
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly(component)) {
            return;
        }
        int oldIndex = ((AbstractUITabGroup)component).getRenderedIndex();
        String clientId = component.getClientId(facesContext);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String newValue = (String)parameters.get(clientId + ACTIVE_INDEX_POSTFIX);
        try {
            int activeIndex = Integer.parseInt(newValue);
            if (activeIndex != oldIndex) {
                TabChangeEvent event = new TabChangeEvent(component, oldIndex, activeIndex);
                component.queueEvent((FacesEvent)event);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Can't parse activeIndex: '" + newValue + "'");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractUITabGroup tabGroup = (AbstractUITabGroup)uiComponent;
        int activeIndex = this.ensureRenderedActiveIndex(facesContext, tabGroup);
        String clientId = tabGroup.getClientId(facesContext);
        String hiddenId = clientId + ACTIVE_INDEX_POSTFIX;
        SwitchType switchType = tabGroup.getSwitchType();
        Markup markup = tabGroup.getMarkup();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute((CssItem)TobagoClass.TAB_GROUP, TobagoClass.TAB_GROUP.createMarkup(markup), new CssItem[]{BootstrapClass.CARD, tabGroup.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)tabGroup);
        writer.writeAttribute(DataAttributes.SWITCH_TYPE, switchType.name(), false);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, activeIndex);
        writer.writeNameAttribute(hiddenId);
        writer.writeIdAttribute(hiddenId);
        writer.endElement(HtmlElements.INPUT);
        if (tabGroup.isShowNavigationBar()) {
            this.encodeHeader(facesContext, writer, tabGroup, activeIndex, switchType);
        }
        this.encodeContent(facesContext, writer, tabGroup, activeIndex, switchType);
        writer.endElement(HtmlElements.DIV);
    }

    private int ensureRenderedActiveIndex(FacesContext context, AbstractUITabGroup tabGroup) {
        ValueExpression expression;
        int activeIndex = tabGroup.getSelectedIndex();
        int index = -1;
        int closestRenderedTabIndex = -1;
        for (UIComponent tab : tabGroup.getChildren()) {
            if (!(tab instanceof AbstractUIPanelBase)) continue;
            if (++index == activeIndex) {
                if (tab.isRendered()) {
                    return index;
                }
                if (closestRenderedTabIndex > -1) break;
            }
            if (!tab.isRendered()) continue;
            closestRenderedTabIndex = index;
            if (index <= activeIndex) continue;
            break;
        }
        if (closestRenderedTabIndex == -1) {
            closestRenderedTabIndex = 0;
        }
        if ((expression = tabGroup.getValueExpression(Attributes.selectedIndex.getName())) != null) {
            expression.setValue(context.getELContext(), (Object)closestRenderedTabIndex);
        } else {
            tabGroup.setSelectedIndex(closestRenderedTabIndex);
        }
        return closestRenderedTabIndex;
    }

    private void encodeHeader(FacesContext facesContext, TobagoResponseWriter writer, AbstractUITabGroup tabGroup, int activeIndex, SwitchType switchType) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CARD_HEADER);
        writer.startElement(HtmlElements.UL);
        writer.writeClassAttribute(TobagoClass.TAB_GROUP__HEADER, BootstrapClass.NAV, BootstrapClass.NAV_TABS, BootstrapClass.CARD_HEADER_TABS);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.TABLIST.toString(), false);
        CommandMap tabGroupMap = RenderUtils.getBehaviorCommands(facesContext, tabGroup);
        int index = 0;
        for (UIComponent child : tabGroup.getChildren()) {
            if (!(child instanceof AbstractUITab)) continue;
            AbstractUITab tab = (AbstractUITab)child;
            if (tab.isRendered()) {
                FacesMessage.Severity maxSeverity;
                Markup markup;
                LabelWithAccessKey label = new LabelWithAccessKey(tab);
                UIComponent labelFacet = ComponentUtils.getFacet((UIComponent)tab, Facets.label);
                UIComponent barFacet = ComponentUtils.getFacet((UIComponent)tab, Facets.bar);
                boolean disabled = tab.isDisabled();
                String tabId = tab.getClientId(facesContext);
                Markup markup2 = markup = tab.getMarkup() != null ? tab.getMarkup() : Markup.NULL;
                if (activeIndex == index) {
                    markup = markup.add(Markup.SELECTED);
                }
                if ((maxSeverity = ComponentUtils.getMaximumSeverityOfChildrenMessages(facesContext, tab)) != null) {
                    markup = markup.add(ComponentUtils.markupOfSeverity(maxSeverity));
                }
                writer.startElement(HtmlElements.LI);
                writer.writeIdAttribute(tabId);
                writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
                writer.writeClassAttribute((CssItem)TobagoClass.TAB, TobagoClass.TAB.createMarkup(markup), new CssItem[]{BootstrapClass.NAV_ITEM, barFacet != null ? TobagoClass.TAB__BAR_FACET : null, tab.getCustomClass()});
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PRESENTATION.toString(), false);
                writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.TAB_GROUP_INDEX, index);
                String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)tab);
                if (title != null) {
                    writer.writeAttribute(HtmlAttributes.TITLE, title, true);
                }
                writer.startElement(HtmlElements.A);
                if (!tab.isDisabled()) {
                    writer.writeAttribute(DataAttributes.TOGGLE, "tab", false);
                }
                if (tab.isDisabled()) {
                    writer.writeClassAttribute(BootstrapClass.NAV_LINK, BootstrapClass.DISABLED);
                } else if (activeIndex == index) {
                    writer.writeClassAttribute(BootstrapClass.NAV_LINK, BootstrapClass.ACTIVE);
                } else {
                    writer.writeClassAttribute(BootstrapClass.NAV_LINK);
                }
                if (!disabled && switchType == SwitchType.client) {
                    writer.writeAttribute(HtmlAttributes.HREF, '#' + this.getTabPanelId(facesContext, tab), false);
                    writer.writeAttribute(DataAttributes.TARGET, '#' + this.getTabPanelId(facesContext, tab).replaceAll(":", "\\\\:"), false);
                }
                if (!disabled) {
                    CommandMap map = RenderUtils.getBehaviorCommands(facesContext, tab);
                    CommandMap.merge(map, tabGroupMap);
                    writer.writeAttribute(DataAttributes.COMMANDS, JsonUtils.encode(map), false);
                }
                if (!disabled && label.getAccessKey() != null) {
                    writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
                    AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), tabId);
                }
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.TAB.toString(), false);
                boolean labelEmpty = true;
                String image = tab.getImage();
                if (image != null && !image.isEmpty()) {
                    writer.startElement(HtmlElements.IMG);
                    writer.writeAttribute(HtmlAttributes.SRC, image, true);
                    writer.endElement(HtmlElements.IMG);
                    labelEmpty = false;
                }
                if (label.getLabel() != null) {
                    HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
                    labelEmpty = false;
                }
                if (labelFacet != null) {
                    labelFacet.encodeAll(facesContext);
                    labelEmpty = false;
                }
                if (labelEmpty) {
                    writer.writeText(Integer.toString(index + 1));
                }
                writer.endElement(HtmlElements.A);
                if (barFacet != null) {
                    writer.startElement(HtmlElements.DIV);
                    barFacet.encodeAll(facesContext);
                    writer.endElement(HtmlElements.DIV);
                }
                writer.endElement(HtmlElements.LI);
            }
            ++index;
        }
        writer.endElement(HtmlElements.UL);
        writer.endElement(HtmlElements.DIV);
    }

    protected void encodeContent(FacesContext facesContext, TobagoResponseWriter writer, AbstractUITabGroup tabGroup, int activeIndex, SwitchType switchType) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CARD_BODY, BootstrapClass.TAB_CONTENT);
        int index = 0;
        for (UIComponent child : tabGroup.getChildren()) {
            if (!(child instanceof AbstractUITab)) continue;
            AbstractUITab tab = (AbstractUITab)child;
            if (tab.isRendered() && (switchType == SwitchType.client || index == activeIndex) && !tab.isDisabled()) {
                Markup markup = tab.getMarkup();
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute((CssItem)TobagoClass.TAB__CONTENT, TobagoClass.TAB__CONTENT.createMarkup(markup), new CssItem[]{BootstrapClass.TAB_PANE, index == activeIndex ? BootstrapClass.ACTIVE : null});
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.TABPANEL.toString(), false);
                writer.writeIdAttribute(this.getTabPanelId(facesContext, tab));
                writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.TAB_GROUP_INDEX, index);
                tab.encodeAll(facesContext);
                writer.endElement(HtmlElements.DIV);
            }
            ++index;
        }
        writer.endElement(HtmlElements.DIV);
    }

    private String getTabPanelId(FacesContext facesContext, AbstractUITab tab) {
        return tab.getClientId(facesContext) + "::" + "content";
    }
}

