/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PartUtils.class);
    private static final Method SUBMITTED_FILE_NAME_METHOD = PartUtils.findSubmittedFileNameMethod();

    private PartUtils() {
    }

    private static Method findSubmittedFileNameMethod() {
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(Part.class).getPropertyDescriptors()) {
                Method readMethod;
                if (!"submittedFileName".equals(pd.getName()) || (readMethod = pd.getReadMethod()) == null) continue;
                return readMethod;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getSubmittedFileName(Part part) {
        String cdl;
        try {
            if (SUBMITTED_FILE_NAME_METHOD != null) {
                String fileName = (String)SUBMITTED_FILE_NAME_METHOD.invoke((Object)part, new Object[0]);
                LOG.debug("Upload file name = '{}'", (Object)fileName);
                return fileName;
            }
        }
        catch (Exception fileName) {
            // empty catch block
        }
        String fileName = null;
        String cd = part.getHeader("Content-Disposition");
        if (cd != null && ((cdl = cd.toLowerCase(Locale.ENGLISH)).startsWith("form-data") || cdl.startsWith("attachment"))) {
            ParameterParser paramParser = new ParameterParser();
            paramParser.setLowerCaseNames(true);
            Map<String, String> params = paramParser.parse(cd, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                if (fileName != null) {
                    fileName = fileName.trim();
                    fileName = fileName.replaceAll("\\\\\\\"", "\"");
                } else {
                    fileName = "";
                }
            }
        }
        LOG.debug("Upload file name = '{}'", fileName);
        return fileName;
    }

    private static class ParameterParser {
        private char[] chars = null;
        private int pos = 0;
        private int len = 0;
        private int i1 = 0;
        private int i2 = 0;
        private boolean lowerCaseNames = false;

        ParameterParser() {
        }

        private boolean hasChar() {
            return this.pos < this.len;
        }

        private String getToken(boolean quoted) {
            while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
                ++this.i1;
            }
            while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
                --this.i2;
            }
            if (quoted && this.i2 - this.i1 >= 2 && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
                ++this.i1;
                --this.i2;
            }
            String result = null;
            if (this.i2 > this.i1) {
                result = new String(this.chars, this.i1, this.i2 - this.i1);
            }
            return result;
        }

        private boolean isOneOf(char ch, char[] charray) {
            boolean result = false;
            for (char element : charray) {
                if (ch != element) continue;
                result = true;
                break;
            }
            return result;
        }

        private String parseToken(char[] terminators) {
            char ch;
            this.i1 = this.pos;
            this.i2 = this.pos;
            while (this.hasChar() && !this.isOneOf(ch = this.chars[this.pos], terminators)) {
                ++this.i2;
                ++this.pos;
            }
            return this.getToken(false);
        }

        private String parseQuotedToken(char[] terminators) {
            this.i1 = this.pos;
            this.i2 = this.pos;
            boolean quoted = false;
            boolean charEscaped = false;
            while (this.hasChar()) {
                char ch = this.chars[this.pos];
                if (!quoted && this.isOneOf(ch, terminators)) break;
                if (!charEscaped && ch == '\"') {
                    quoted = !quoted;
                }
                charEscaped = !charEscaped && ch == '\\';
                ++this.i2;
                ++this.pos;
            }
            return this.getToken(true);
        }

        public void setLowerCaseNames(boolean b) {
            this.lowerCaseNames = b;
        }

        public Map<String, String> parse(String str, char separator) {
            if (str == null) {
                return new HashMap<String, String>();
            }
            return this.parse(str.toCharArray(), separator);
        }

        public Map<String, String> parse(char[] charArray, char separator) {
            if (charArray == null) {
                return new HashMap<String, String>();
            }
            return this.parse(charArray, 0, charArray.length, separator);
        }

        public Map<String, String> parse(char[] charArray, int offset, int length, char separator) {
            if (charArray == null) {
                return new HashMap<String, String>();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            this.chars = charArray;
            this.pos = offset;
            this.len = length;
            while (this.hasChar()) {
                String paramName = this.parseToken(new char[]{'=', separator});
                String paramValue = null;
                if (this.hasChar() && charArray[this.pos] == '=') {
                    ++this.pos;
                    paramValue = this.parseQuotedToken(new char[]{separator});
                }
                if (this.hasChar() && charArray[this.pos] == separator) {
                    ++this.pos;
                }
                if (paramName == null || paramName.length() <= 0) continue;
                if (this.lowerCaseNames) {
                    paramName = paramName.toLowerCase(Locale.ENGLISH);
                }
                params.put(paramName, paramValue);
            }
            return params;
        }
    }
}

