// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import javax.el.ELException;
import javax.faces.FacesException;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/** 
 <p>
  WARNING: This component is preliminary and may be changed without a major release.
  </p>

  Renders a GridLayout.
  <pre>
  columns/rows ::= LAYOUT
  LAYOUT       ::= TOKEN [";" TOKEN]+
  TOKEN        ::= AUTO | PIXEL | PROPORTIONAL
  AUTO         ::= "auto" | "fixed"
  PIXEL        ::= NUMBER "px"
  PROPORTIONAL ::= [NUMBER] "*"
  </pre>
  <table border="1">
  <caption>GridLayout</caption>
  <tr>
  <th>Parent</th>
  <th>Child</th>
  <th>Okay?</th>
  <th>Remarks</th>
  </tr>
  <tr>
  <td>AUTO</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  <tr>
  <td>AUTO</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>wrong</td>
  <td>Layout manager cannot compute the auto value.</td>
  </tr>
  <tr>
  <td>PIXEL</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>potentially wrong</td>
  <td>The values depend on each other, the programmer has to keep consistency manually.</td>
  </tr>
  <tr>
  <td>PIXEL</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  <tr>
  <td>PROPORTIONAL</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>potentially wrong</td>
  <td>No automatic matching:<ul><li>too little space: scroll bar</li>
  <li>too much space: elements will be spread.</li></ul></td>
  </tr>
  <tr>
  <td>PROPORTIONAL</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  </table>
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.GridLayoutTagDeclaration}.
 */
public class UIGridLayout
    extends AbstractUIGridLayout implements Visual {

  public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.GridLayout";

  public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.GridLayout";


  enum PropertyKeys {
    columnSpacing,
    markup,
    columns,
    customClass,
    style,
    rowSpacing,
    rows,
    rigid,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  Spacing between the columns in the actual layout.

  */
  public org.apache.myfaces.tobago.layout.Measure getColumnSpacing() {
    Object object = getStateHelper().eval(PropertyKeys.columnSpacing);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return Measure.ZERO;
  }

  public void setColumnSpacing(org.apache.myfaces.tobago.layout.Measure columnSpacing) {
    getStateHelper().put(PropertyKeys.columnSpacing, columnSpacing);
  }

  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    Object object = getStateHelper().eval(PropertyKeys.markup);
    if (object != null) {
      return Markup.valueOf(object);
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    getStateHelper().put(PropertyKeys.markup, markup);
  }

  /**
  This value defines the layout constraints for column layout.
   It is a semicolon separated list of layout tokens '[&lt;n&gt;]*', '&lt;n&gt;px' or 'auto'.
   Where &lt;n&gt; is a non negative integer and the square brackets means optional.
   Example: '2*;*;100px;auto'.
  <br>Default: <code>1*</code>
  */
  public java.lang.String getColumns() {
    java.lang.String columns = (java.lang.String) getStateHelper().eval(PropertyKeys.columns);
    if (columns != null) {
      return columns;
    }
    return "1*";
  }

  public void setColumns(java.lang.String columns) {
    getStateHelper().put(PropertyKeys.columns, columns);
  }

  /**
  Sets a CSS class in its parent, if the parent supports it.

   Which this feature it is possible to put a CSS class name into a component with the &lt;tc:style&gt; tag. Example:

   <pre>
   &lt;tc:in&gt;
     &lt;tc:style customClass="my-emphasized"/&gt;
   &lt;/tc:in&gt;
   </pre>

   One capability is, to used external CSS libs.
   <br>
   This feature should not be used imprudent.
   Because it might be unstable against changes in the renderered HTML code.

  */
  public org.apache.myfaces.tobago.renderkit.css.CustomClass getCustomClass() {
    return (org.apache.myfaces.tobago.renderkit.css.CustomClass) getStateHelper().eval(PropertyKeys.customClass);
  }

  public void setCustomClass(org.apache.myfaces.tobago.renderkit.css.CustomClass customClass) {
    getStateHelper().put(PropertyKeys.customClass, customClass);
  }

  /**
  For internal use. Used for rendering, if there is a child tag &lt;tc:style&gt;

  */
  public org.apache.myfaces.tobago.renderkit.css.Style getStyle() {
    return (org.apache.myfaces.tobago.renderkit.css.Style) getStateHelper().eval(PropertyKeys.style);
  }

  public void setStyle(org.apache.myfaces.tobago.renderkit.css.Style style) {
    getStateHelper().put(PropertyKeys.style, style);
  }

  /**
  Spacing between the rows in the actual layout.

  */
  public org.apache.myfaces.tobago.layout.Measure getRowSpacing() {
    Object object = getStateHelper().eval(PropertyKeys.rowSpacing);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return Measure.ZERO;
  }

  public void setRowSpacing(org.apache.myfaces.tobago.layout.Measure rowSpacing) {
    getStateHelper().put(PropertyKeys.rowSpacing, rowSpacing);
  }

  /**
  This value defines the layout constraints for row layout.
   It is a semicolon separated list of layout tokens '[&lt;n&gt;]*', '&lt;n&gt;px' or 'auto'.
   Where &lt;n&gt; is a non negative integer and the square brackets means optional.
   Example: '2*;*;100px;auto'.
  <br>Default: <code>1*</code>
  */
  public java.lang.String getRows() {
    java.lang.String rows = (java.lang.String) getStateHelper().eval(PropertyKeys.rows);
    if (rows != null) {
      return rows;
    }
    return "1*";
  }

  public void setRows(java.lang.String rows) {
    getStateHelper().put(PropertyKeys.rows, rows);
  }

  /**
  This attribute advises the layout manager, to not use space that comes from non rendered components.

  */
  public boolean isRigid() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.rigid);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setRigid(boolean rigid) {
    getStateHelper().put(PropertyKeys.rigid, rigid);
  }


}