/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.config.ContentSecurityPolicy;
import org.apache.myfaces.tobago.internal.config.TobagoConfigBuilder;
import org.apache.myfaces.tobago.internal.util.MimeTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoServletContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoServletContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext;
        if (LOG.isInfoEnabled()) {
            LOG.info("*** contextInitialized ***");
        }
        if ((servletContext = event.getServletContext()).getAttribute("org.apache.myfaces.tobago.config.TobagoConfig") != null) {
            LOG.warn("Tobago has been already initialized. Do nothing.");
            return;
        }
        TobagoConfigBuilder.init(servletContext);
        if (LOG.isInfoEnabled()) {
            TobagoConfig tobagoConfig = TobagoConfig.getInstance(servletContext);
            LOG.info("TobagoConfig: " + tobagoConfig);
            MimeTypeUtils.init(servletContext);
            ContentSecurityPolicy.Mode mode = tobagoConfig.getContentSecurityPolicy().getMode();
            StringBuilder builder = new StringBuilder();
            builder.append("\n*************************************************************************************");
            builder.append("\nNote: CSP is ");
            builder.append((Object)mode);
            if (mode == ContentSecurityPolicy.Mode.ON) {
                builder.append("\nYou may need to check application specific JavaScript code.");
                builder.append("\nOtherwise the application will not run in modern browsers, that are supporting CSP.");
                builder.append("\nFor more information see http://myfaces.apache.org/tobago/migration-2.0.html");
            }
            builder.append("\n*************************************************************************************");
            String note = builder.toString();
            LOG.info(note);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (LOG.isInfoEnabled()) {
            LOG.info("*** contextDestroyed ***\n--- snip -----------------------------------------------------------------------");
        }
        ServletContext servletContext = event.getServletContext();
        servletContext.removeAttribute("org.apache.myfaces.tobago.config.TobagoConfig");
    }
}

