/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectMany;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.view.facelets.FaceletContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TransientStateHolder;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.component.AbstractUIFormBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentUtils.class);
    public static final String SUB_SEPARATOR = "::";
    private static final String RENDER_KEY_PREFIX = "org.apache.myfaces.tobago.util.ComponentUtils.RendererKeyPrefix_";
    private static final String PAGE_KEY = "org.apache.myfaces.tobago.Page.Key";
    public static final Class[] ACTION_ARGS = new Class[0];
    public static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    public static final Class[] VALUE_CHANGE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};
    public static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    public static final String LIST_SEPARATOR_CHARS = ", ";
    public static final String DATA_ATTRIBUTES_KEY = "javax.faces.component.DATA_ATTRIBUTES_KEY";

    private ComponentUtils() {
    }

    public static boolean hasErrorMessages(FacesContext context) {
        Iterator iter = context.getMessages();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            if (FacesMessage.SEVERITY_ERROR.compareTo((Object)message.getSeverity()) > 0) continue;
            return true;
        }
        return false;
    }

    public static String getFacesMessageAsString(FacesContext facesContext, UIComponent component) {
        Iterator messages = facesContext.getMessages(component.getClientId(facesContext));
        StringBuilder stringBuffer = new StringBuilder();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            stringBuffer.append(message.getDetail());
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static boolean isInPopup(UIComponent component) {
        while (component != null) {
            if (component instanceof AbstractUIPopup) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static void resetPage(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            view.getAttributes().remove(PAGE_KEY);
        }
    }

    public static UIViewRoot findViewRoot(FaceletContext faceletContext, UIComponent component) {
        UIViewRoot viewRoot = ComponentUtils.findAncestor(component, UIViewRoot.class);
        if (viewRoot != null) {
            return viewRoot;
        }
        return faceletContext.getFacesContext().getViewRoot();
    }

    public static AbstractUIPage findPage(FacesContext context, UIComponent component) {
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            TransientStateHolder stateHolder = (TransientStateHolder)view.getAttributes().get(PAGE_KEY);
            if (stateHolder == null || stateHolder.isEmpty()) {
                AbstractUIPage page = ComponentUtils.findPage(component);
                stateHolder = new TransientStateHolder(page);
                context.getViewRoot().getAttributes().put(PAGE_KEY, stateHolder);
            }
            return (AbstractUIPage)stateHolder.get();
        }
        return ComponentUtils.findPage(component);
    }

    public static AbstractUIPage findPage(UIComponent component) {
        if (component instanceof UIViewRoot) {
            return ComponentUtils.findPageBreadthFirst(component);
        }
        while (component != null) {
            if (component instanceof AbstractUIPage) {
                return (AbstractUIPage)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static AbstractUIPage findPage(FacesContext facesContext) {
        return ComponentUtils.findPageBreadthFirst((UIComponent)facesContext.getViewRoot());
    }

    private static AbstractUIPage findPageBreadthFirst(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractUIPage)) continue;
            return (AbstractUIPage)child;
        }
        for (UIComponent child : component.getChildren()) {
            AbstractUIPage result = ComponentUtils.findPageBreadthFirst(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static AbstractUIFormBase findForm(UIComponent component) {
        while (component != null) {
            if (component instanceof AbstractUIFormBase) {
                return (AbstractUIFormBase)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static <T> T findAncestor(UIComponent component, Class<T> type) {
        while (component != null) {
            if (type.isAssignableFrom(component.getClass())) {
                return (T)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static List<AbstractUIForm> findSubForms(UIComponent component) {
        ArrayList<AbstractUIForm> collect = new ArrayList<AbstractUIForm>();
        ComponentUtils.findSubForms(collect, component);
        return collect;
    }

    private static void findSubForms(List<AbstractUIForm> collect, UIComponent component) {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (child instanceof AbstractUIForm) {
                collect.add((AbstractUIForm)child);
                continue;
            }
            ComponentUtils.findSubForms(collect, child);
        }
    }

    public static <T extends UIComponent> T findDescendant(UIComponent component, Class<T> type) {
        for (UIComponent child : component.getChildren()) {
            if (type.isAssignableFrom(child.getClass())) {
                return (T)child;
            }
            T descendant = ComponentUtils.findDescendant(child, type);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    public static <T extends UIComponent> T findFacetDescendant(UIComponent component, Facets facet, Class<T> type) {
        UIComponent facetComponent = component.getFacet(facet.name());
        if (facetComponent != null) {
            if (type.isAssignableFrom(facetComponent.getClass())) {
                return (T)facetComponent;
            }
            return ComponentUtils.findDescendant(facetComponent, type);
        }
        return null;
    }

    public static <T extends UIComponent> T findChild(UIComponent component, Class<T> type) {
        for (UIComponent child : component.getChildren()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            return (T)child;
        }
        return null;
    }

    public static <T extends UIComponent> List<T> findDescendantList(UIComponent component, Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (UIComponent child : component.getChildren()) {
            if (type.isAssignableFrom(child.getClass())) {
                result.add(child);
            }
            result.addAll(ComponentUtils.findDescendantList(child, type));
        }
        return result;
    }

    public static String findClientIdFor(UIComponent component, FacesContext facesContext) {
        UIComponent forComponent = ComponentUtils.findFor(component);
        if (forComponent != null) {
            String clientId = forComponent.getClientId(facesContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug("found clientId: '" + clientId + "'");
            }
            return clientId;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("found no clientId");
        }
        return null;
    }

    public static UIComponent findFor(UIComponent component) {
        String forValue = ComponentUtils.getStringAttribute(component, Attributes.forValue);
        if (forValue == null) {
            return component.getParent();
        }
        return ComponentUtils.findComponent(component, forValue);
    }

    public static void evaluateAutoFor(UIComponent component, Class<? extends UIComponent> clazz) {
        String forComponent = ComponentUtils.getStringAttribute(component, Attributes.forValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug("for = '" + forComponent + "'");
        }
        if ("@auto".equals(forComponent)) {
            for (UIComponent child : component.getParent().getChildren()) {
                if (!ComponentUtils.setForToInput(component, child, clazz, component instanceof NamingContainer)) continue;
                return;
            }
            for (UIComponent child : component.getParent().getParent().getChildren()) {
                if (!ComponentUtils.setForToInput(component, child, clazz, component.getParent() instanceof NamingContainer)) continue;
                return;
            }
        }
    }

    private static boolean setForToInput(UIComponent component, UIComponent child, Class<? extends UIComponent> clazz, boolean namingContainer) {
        if (clazz.isAssignableFrom(child.getClass())) {
            String forComponent = namingContainer ? ":::" + child.getId() : child.getId();
            ComponentUtils.setAttribute(component, Attributes.forValue, forComponent);
            return true;
        }
        return false;
    }

    public static boolean isInActiveForm(UIComponent component) {
        while (component != null) {
            AbstractUIFormBase form;
            if (component instanceof AbstractUIFormBase && (form = (AbstractUIFormBase)component).isSubmitted()) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static FacesMessage.Severity getMaximumSeverity(UIComponent component) {
        boolean invalid = component instanceof UIInput && !((UIInput)component).isValid();
        FacesMessage.Severity max = invalid ? FacesMessage.SEVERITY_ERROR : null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Iterator messages = facesContext.getMessages(component.getClientId(facesContext));
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (max != null && message.getSeverity().getOrdinal() <= max.getOrdinal()) continue;
            max = message.getSeverity();
        }
        return max;
    }

    public static boolean isError(UIInput uiInput) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return !uiInput.isValid() || facesContext.getMessages(uiInput.getClientId(facesContext)).hasNext();
    }

    public static boolean isError(UIComponent component) {
        if (component instanceof AbstractUIInput) {
            return ComponentUtils.isError((AbstractUIInput)component);
        }
        return false;
    }

    public static boolean isOutputOnly(UIComponent component) {
        return ComponentUtils.getBooleanAttribute(component, Attributes.disabled) || ComponentUtils.getBooleanAttribute(component, Attributes.readonly);
    }

    public static Object getAttribute(UIComponent component, Attributes name) {
        return component.getAttributes().get(name.getName());
    }

    public static boolean getBooleanAttribute(UIComponent component, Attributes name) {
        return ComponentUtils.getBooleanAttribute(component, name, false);
    }

    public static boolean getBooleanAttribute(UIComponent component, Attributes name, boolean defaultValue) {
        Object bool = component.getAttributes().get(name.getName());
        if (bool == null) {
            return defaultValue;
        }
        if (bool instanceof Boolean) {
            return (Boolean)bool;
        }
        return Boolean.valueOf(bool.toString());
    }

    public static String getStringAttribute(UIComponent component, Attributes name) {
        return ComponentUtils.getStringAttribute(component, name, null);
    }

    public static String getStringAttribute(UIComponent component, Attributes name, String defaultValue) {
        String result = (String)ComponentUtils.getAttribute(component, name);
        return result != null ? result : defaultValue;
    }

    public static int getIntAttribute(UIComponent component, Attributes name) {
        return ComponentUtils.getIntAttribute(component, name, 0);
    }

    public static int getIntAttribute(UIComponent component, Attributes name, int defaultValue) {
        Object integer = component.getAttributes().get(name.getName());
        if (integer instanceof Number) {
            return ((Number)integer).intValue();
        }
        if (integer instanceof String) {
            try {
                return Integer.parseInt((String)integer);
            }
            catch (NumberFormatException e) {
                LOG.warn("Can't parse number from string : \"" + integer + "\"!");
                return defaultValue;
            }
        }
        if (integer == null) {
            return defaultValue;
        }
        LOG.warn("Unknown type '" + integer.getClass().getName() + "' for integer attribute: " + (Object)((Object)name) + " comp: " + component);
        return defaultValue;
    }

    public static Character getCharacterAttribute(UIComponent component, Attributes name) {
        Object character = ComponentUtils.getAttribute(component, name);
        if (character == null) {
            return null;
        }
        if (character instanceof Character) {
            return (Character)character;
        }
        if (character instanceof String) {
            String asString = (String)character;
            return asString.length() > 0 ? Character.valueOf(asString.charAt(0)) : null;
        }
        LOG.warn("Unknown type '" + character.getClass().getName() + "' for integer attribute: " + (Object)((Object)name) + " comp: " + component);
        return null;
    }

    public static void setAttribute(UIComponent component, Attributes name, Object value) {
        component.getAttributes().put(name.getName(), value);
    }

    public static void removeAttribute(UIComponent component, Attributes name) {
        component.getAttributes().remove(name.getName());
    }

    public static UIComponent getFacet(UIComponent component, Facets facet) {
        return component.getFacet(facet.name());
    }

    public static void setFacet(UIComponent component, Facets facet, UIComponent child) {
        component.getFacets().put(facet.name(), child);
    }

    public static boolean isFacetOf(UIComponent component, UIComponent parent) {
        for (Object o : parent.getFacets().keySet()) {
            UIComponent facet = parent.getFacet((String)o);
            if (!component.equals(facet)) continue;
            return true;
        }
        return false;
    }

    public static RendererBase getRenderer(FacesContext facesContext, UIComponent component) {
        return ComponentUtils.getRenderer(facesContext, component.getFamily(), component.getRendererType());
    }

    public static RendererBase getRenderer(FacesContext facesContext, String family, String rendererType) {
        if (rendererType == null) {
            return null;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        StringBuilder key = new StringBuilder(RENDER_KEY_PREFIX);
        key.append(rendererType);
        RendererBase renderer = (RendererBase)((Object)requestMap.get(key.toString()));
        if (renderer == null) {
            Renderer myRenderer = ComponentUtils.getRendererInternal(facesContext, family, rendererType);
            if (myRenderer instanceof RendererBase) {
                requestMap.put(key.toString(), myRenderer);
                renderer = (RendererBase)myRenderer;
            } else {
                return null;
            }
        }
        return renderer;
    }

    private static Renderer getRendererInternal(FacesContext facesContext, String family, String rendererType) {
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
        Renderer myRenderer = renderKit.getRenderer(family, rendererType);
        return myRenderer;
    }

    public static Object findParameter(UIComponent component, String name) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Select name='" + parameter.getName() + "'");
                LOG.debug("Select value='" + parameter.getValue() + "'");
            }
            if (!name.equals(parameter.getName())) continue;
            return parameter.getValue();
        }
        return null;
    }

    public static UIComponent findComponent(UIComponent from, String relativeId) {
        int colonCount;
        UIComponent from1 = from;
        String relativeId1 = relativeId;
        int idLength = relativeId1.length();
        if (idLength > 0 && relativeId1.charAt(0) == '@' && relativeId1.equals("@this")) {
            return from1;
        }
        for (colonCount = 0; colonCount < idLength && relativeId1.charAt(colonCount) == UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()); ++colonCount) {
        }
        if (colonCount > 1) {
            relativeId1 = relativeId1.substring(colonCount);
            for (int j = 1; j < colonCount; ++j) {
                while (from1.getParent() != null && !((from1 = from1.getParent()) instanceof NamingContainer)) {
                }
            }
        }
        return from1.findComponent(relativeId1);
    }

    public static String evaluateClientIds(FacesContext context, UIComponent component, String[] componentIds) {
        ArrayList<String> result = new ArrayList<String>(componentIds.length);
        for (String id : componentIds) {
            String clientId;
            if (StringUtils.isBlank(id) || (clientId = ComponentUtils.evaluateClientId(context, component, id)) == null) continue;
            result.add(clientId);
        }
        if (result.isEmpty()) {
            return null;
        }
        return StringUtils.join(result, ' ');
    }

    public static String evaluateClientId(FacesContext context, UIComponent component, String componentId) {
        UIComponent partiallyComponent = ComponentUtils.findComponent(component, componentId);
        if (partiallyComponent != null) {
            int rowIndex;
            String clientId = partiallyComponent.getClientId(context);
            if (partiallyComponent instanceof AbstractUISheet && (rowIndex = ((AbstractUISheet)partiallyComponent).getRowIndex()) >= 0 && clientId.endsWith(Integer.toString(rowIndex))) {
                return clientId.substring(0, clientId.lastIndexOf(UINamingContainer.getSeparatorChar((FacesContext)context)));
            }
            return clientId;
        }
        LOG.error("No component found for id='" + componentId + "', search base component is '" + component.getClientId(context) + "'");
        return null;
    }

    public static String[] splitList(String renderers) {
        return StringUtils.split(renderers, LIST_SEPARATOR_CHARS);
    }

    public static Object getConvertedValue(FacesContext facesContext, UIComponent component, String stringValue) {
        try {
            RendererBase renderer = ComponentUtils.getRenderer(facesContext, component);
            if (renderer != null) {
                if (component instanceof UISelectMany) {
                    Object converted = renderer.getConvertedValue(facesContext, component, new String[]{stringValue});
                    return converted instanceof Collection ? CollectionUtils.get((Object)converted, (int)0) : ((Object[])converted)[0];
                }
                return renderer.getConvertedValue(facesContext, component, stringValue);
            }
            if (component instanceof ValueHolder) {
                Class valueType;
                ValueBinding vb;
                Converter converter = ((ValueHolder)component).getConverter();
                if (converter == null && (vb = component.getValueBinding("value")) != null && (valueType = vb.getType(facesContext)) != null) {
                    converter = facesContext.getApplication().createConverter(valueType);
                }
                if (converter != null) {
                    converter.getAsObject(facesContext, component, stringValue);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Can't convert string value '" + stringValue + "'", (Throwable)e);
        }
        return stringValue;
    }

    public static Markup updateMarkup(UIComponent component, Markup markup) {
        if (markup == null) {
            markup = Markup.NULL;
        }
        if (ComponentUtils.getBooleanAttribute(component, Attributes.disabled)) {
            markup = markup.add(Markup.DISABLED);
        }
        if (ComponentUtils.getBooleanAttribute(component, Attributes.readonly)) {
            markup = markup.add(Markup.READONLY);
        }
        if (component instanceof UIInput) {
            UIInput input = (UIInput)component;
            FacesMessage.Severity maximumSeverity = ComponentUtils.getMaximumSeverity((UIComponent)input);
            markup = markup.add(ComponentUtils.markupOfSeverity(maximumSeverity));
            if (input.isRequired()) {
                markup = markup.add(Markup.REQUIRED);
            }
        }
        return markup;
    }

    public static Markup markupOfSeverity(FacesMessage.Severity maximumSeverity) {
        if (FacesMessage.SEVERITY_FATAL.equals(maximumSeverity)) {
            return Markup.FATAL;
        }
        if (FacesMessage.SEVERITY_ERROR.equals(maximumSeverity)) {
            return Markup.ERROR;
        }
        if (FacesMessage.SEVERITY_WARN.equals(maximumSeverity)) {
            return Markup.WARN;
        }
        if (FacesMessage.SEVERITY_INFO.equals(maximumSeverity)) {
            return Markup.INFO;
        }
        return null;
    }

    public static FacesMessage.Severity getMaximumSeverityOfChildrenMessages(FacesContext facesContext, NamingContainer container) {
        if (container instanceof UIComponent) {
            String clientId = ((UIComponent)container).getClientId(facesContext);
            FacesMessage.Severity max = null;
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                if (id == null || !id.startsWith(clientId)) continue;
                Iterator messages = facesContext.getMessages(id);
                while (messages.hasNext()) {
                    FacesMessage message = (FacesMessage)messages.next();
                    if (max != null && message.getSeverity().getOrdinal() <= max.getOrdinal()) continue;
                    max = message.getSeverity();
                }
            }
            return max;
        }
        return null;
    }

    public static void putDataAttributeWithPrefix(UIComponent component, DataAttributes name, Object value) {
        if (name.getValue().startsWith("data-")) {
            ComponentUtils.putDataAttribute(component, name.getValue().substring(5), value);
        } else {
            LOG.error("The name must start with 'data-' but it doesn't: '" + name + "'");
        }
    }

    public static void putDataAttribute(UIComponent component, Object name, Object value) {
        Map<Object, Object> map = ComponentUtils.getDataAttributes(component);
        if (map == null) {
            map = new HashMap<Object, Object>();
            component.getAttributes().put(DATA_ATTRIBUTES_KEY, map);
        }
        map.put(name, value);
    }

    public static Map<Object, Object> getDataAttributes(UIComponent component) {
        return (Map)component.getAttributes().get(DATA_ATTRIBUTES_KEY);
    }

    public static Object getDataAttribute(UIComponent component, String name) {
        Map<Object, Object> map = ComponentUtils.getDataAttributes(component);
        return map != null ? map.get(name) : null;
    }

    public static Converter getConverter(FacesContext facesContext, UIComponent component, Object value) {
        ValueExpression valueExpression;
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && (valueExpression = component.getValueExpression("value")) != null) {
            Class<?> converterType = null;
            try {
                converterType = valueExpression.getType(facesContext.getELContext());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (converterType == null && value != null) {
                converterType = value.getClass();
            }
            if (converterType != null && converterType != Object.class) {
                converter = facesContext.getApplication().createConverter(converterType);
            }
        }
        return converter;
    }

    public static String getFormattedValue(FacesContext facesContext, UIComponent component, Object currentValue) throws ConverterException {
        if (currentValue == null) {
            return "";
        }
        Converter converter = ComponentUtils.getConverter(facesContext, component, currentValue);
        if (converter != null) {
            return converter.getAsString(facesContext, component, currentValue);
        }
        return currentValue.toString();
    }

    public static UIComponent createComponent(FacesContext facesContext, String componentType, RendererTypes rendererType, String clientId) {
        UIComponent component = facesContext.getApplication().createComponent(componentType);
        if (rendererType != null) {
            component.setRendererType(rendererType.name());
        }
        component.setId(clientId);
        return component;
    }
}

