/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.util.IoUtils;
import org.apache.myfaces.tobago.internal.util.MimeTypeUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -4491419290205206466L;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private Long expires;
    private int bufferSize;
    private boolean nosniffHeader;

    public void init(ServletConfig servletConfig) throws ServletException {
        String expiresString;
        super.init(servletConfig);
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(servletConfig.getServletContext());
        if (tobagoConfig.getProjectStage() == ProjectStage.Production) {
            this.expires = 86400000L;
        }
        if ((expiresString = servletConfig.getInitParameter("expires")) != null) {
            try {
                this.expires = new Long(expiresString) * 1000L;
            }
            catch (NumberFormatException e) {
                LOG.error("Caught: " + e.getMessage(), (Throwable)e);
            }
        }
        String bufferSizeString = servletConfig.getInitParameter("bufferSize");
        this.bufferSize = 4096;
        if (bufferSizeString != null) {
            try {
                this.bufferSize = Integer.parseInt(bufferSizeString);
            }
            catch (NumberFormatException e) {
                LOG.error("Caught: " + e.getMessage(), (Throwable)e);
            }
        }
        this.nosniffHeader = tobagoConfig.isSetNosniffHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InputStream inputStream;
        block8: {
            String contentType;
            String requestURI = request.getRequestURI();
            String resource = requestURI.substring(request.getContextPath().length() + 1);
            if (this.expires != null) {
                response.setDateHeader("Last-Modified", 0L);
                response.setHeader("Cache-Control", "Public, max-age=" + this.expires);
                response.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
            }
            if ((contentType = MimeTypeUtils.getMimeTypeForFile(requestURI)) != null) {
                response.setContentType(contentType);
                if (this.nosniffHeader) {
                    ResponseUtils.ensureNosniffHeader(response);
                }
            } else {
                String message = "Unsupported mime type of resource='" + resource + "'";
                LOG.warn(message + " (because of security reasons)");
                response.setStatus(403);
                return;
            }
            inputStream = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                inputStream = classLoader.getResourceAsStream("META-INF/resources/" + resource);
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream(resource);
                }
                if (inputStream != null) {
                    this.copy(inputStream, (OutputStream)response.getOutputStream());
                    break block8;
                }
                String message = "Resource '" + resource + "' not found!";
                LOG.warn(message);
                response.setStatus(404);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(inputStream);
    }

    protected long getLastModified(HttpServletRequest request) {
        if (this.expires != null) {
            return 0L;
        }
        return super.getLastModified(request);
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[this.bufferSize];
        while (-1 != (count = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, count);
        }
    }
}

