/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import org.apache.myfaces.tobago.layout.AlignItems;
import org.apache.myfaces.tobago.layout.JustifyContent;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TobagoClass implements CssItem
{
    ALIGN_ITEMS__BASELINE("tobago-alignItems-baseline"),
    ALIGN_ITEMS__CENTER("tobago-alignItems-center"),
    ALIGN_ITEMS__FLEX_END("tobago-alignItems-flexEnd"),
    ALIGN_ITEMS__FLEX_START("tobago-alignItems-flexStart"),
    ALIGN_ITEMS__STRETCH("tobago-alignItems-stretch"),
    JUSTIFY_CONTENT__CENTER("tobago-justifyContent-center"),
    JUSTIFY_CONTENT__FLEX_START("tobago-justifyContent-flexStart"),
    JUSTIFY_CONTENT__FLEX_END("tobago-justifyContent-flexEnd"),
    JUSTIFY_CONTENT__SPACE_BETWEEN("tobago-justifyContent-spaceBetween"),
    JUSTIFY_CONTENT__SPACE_AROUND("tobago-justifyContent-spaceAround"),
    DROPDOWN__SUBMENU("tobago-dropdown-submenu"),
    DROPDOWN_SUBMENU(DROPDOWN__SUBMENU.getName()),
    TABLE_LAYOUT__FIXED("tobago-tableLayout-fixed"),
    HAS__INFO("tobago-has-info"),
    HAS_INFO(HAS__INFO.getName()),
    REQUIRED("tobago-required"),
    SPREAD("tobago-spread"),
    BOX__HEADER("tobago-box-header"),
    COLLAPSED("tobago-collapsed"),
    FLEX_LAYOUT("tobago-flexLayout"),
    FIGURE("tobago-figure"),
    FORM("tobago-form"),
    INPUT__GROUP__OUTER("tobago-input-group-outer"),
    INPUT_GROUP_OUTER(INPUT__GROUP__OUTER.getName()),
    LABEL("tobago-label"),
    MESSAGES("tobago-messages"),
    PAGE__MENU_STORE("tobago-page-menuStore"),
    PANEL("tobago-panel"),
    POPUP("tobago-popup"),
    SECTION__HEADER("tobago-section-header"),
    SECTION__CONTENT("tobago-section-content"),
    SELECT_MANY_CHECKBOX__INLINE("tobago-selectManyCheckbox-inline"),
    SELECT_ONE_RADIO__INLINE("tobago-selectOneRadio-inline"),
    SHEET__HEADER("tobago-sheet-header"),
    SHEET__BODY_TABLE("tobago-sheet-bodyTable"),
    SHEET__COLUMN_SELECTOR("tobago-sheet-columnSelector"),
    SHEET__HEADER_TABLE("tobago-sheet-headerTable"),
    SHEET__PAGING_INPUT("tobago-sheet-pagingInput"),
    SHEET__PAGING_OUTPUT("tobago-sheet-pagingOutput"),
    SHEET__CELL__MARKUP__RIGHT("tobago-sheet-cell-markup-right"),
    SHEET__CELL__MARKUP__CENTER("tobago-sheet-cell-markup-center"),
    SHEET__CELL__MARKUP__JUSTIFY("tobago-sheet-cell-markup-justify"),
    SUGGEST("tobago-suggest"),
    TREE_NODE__TOGGLE("tobago-treeNode-toggle");

    private static final Logger LOG;
    private final String name;

    private TobagoClass(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static TobagoClass valueOf(AlignItems alignItems) {
        if (alignItems == null) {
            return null;
        }
        switch (alignItems) {
            case baseline: {
                return ALIGN_ITEMS__BASELINE;
            }
            case center: {
                return ALIGN_ITEMS__CENTER;
            }
            case flexEnd: {
                return ALIGN_ITEMS__FLEX_END;
            }
            case flexStart: {
                return ALIGN_ITEMS__FLEX_START;
            }
            case stretch: {
                return ALIGN_ITEMS__STRETCH;
            }
        }
        LOG.warn("Undefined alignItems: '{}'.", (Object)alignItems);
        return null;
    }

    public static TobagoClass valueOf(JustifyContent justifyContent) {
        if (justifyContent == null) {
            return null;
        }
        switch (justifyContent) {
            case center: {
                return JUSTIFY_CONTENT__CENTER;
            }
            case flexEnd: {
                return JUSTIFY_CONTENT__FLEX_END;
            }
            case flexStart: {
                return JUSTIFY_CONTENT__FLEX_START;
            }
            case spaceBetween: {
                return JUSTIFY_CONTENT__SPACE_BETWEEN;
            }
            case spaceAround: {
                return JUSTIFY_CONTENT__SPACE_AROUND;
            }
        }
        LOG.warn("Undefined justifyContent: '{}'.", (Object)justifyContent);
        return null;
    }

    static {
        LOG = LoggerFactory.getLogger(TobagoClass.class);
    }
}

