/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollPosition
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ScrollPosition.class);
    private Integer left;
    private Integer top;

    public String encode() {
        return (this.left != null ? this.left : "0") + ";" + (this.top != null ? this.top : "0");
    }

    public void clear() {
        this.top = null;
        this.left = null;
    }

    public void update(String value) {
        if (StringUtils.isBlank(value)) {
            this.top = null;
            this.left = null;
        } else {
            int sep = value.indexOf(";");
            if (sep == -1) {
                LOG.warn("Can't parse: '{}'", (Object)value);
                return;
            }
            this.left = Integer.parseInt(value.substring(0, sep));
            this.top = Integer.parseInt(value.substring(sep + 1));
        }
    }

    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }
}

