/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import java.io.Serializable;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Measure
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Measure.class);
    public static final Measure ZERO = Measure.valueOf(0);
    private final Double d;
    private final Integer i;
    private final Unit unit;

    public Measure(int i, Unit unit) {
        this.d = null;
        this.i = i;
        this.unit = unit;
    }

    public Measure(double d, Unit unit) {
        this.d = d;
        this.i = null;
        this.unit = unit;
    }

    public Measure(String string, Unit unit) {
        if (string.contains(".")) {
            this.d = Double.parseDouble(string);
            this.i = null;
        } else {
            this.d = null;
            this.i = Integer.parseInt(string);
        }
        this.unit = unit;
    }

    public static Measure valueOf(Measure value) {
        if (value == null) {
            return ZERO;
        }
        return value;
    }

    public static Measure valueOf(int value) {
        return new Measure(value, Unit.PX);
    }

    public static Measure valueOf(Integer value) {
        if (value == null) {
            return ZERO;
        }
        return Measure.valueOf((int)value);
    }

    public static Measure valueOf(Number value) {
        if (value == null) {
            return ZERO;
        }
        return Measure.valueOf(value.doubleValue());
    }

    public static Measure valueOf(String value) {
        try {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            int length = value.length();
            if (value.endsWith("%")) {
                return new Measure(value.substring(0, length - 1), Unit.PERCENT);
            }
            if (length >= 2 && Character.isLetter(value.charAt(length - 2))) {
                return new Measure(value.substring(0, length - 2), Unit.valueOf(value.substring(length - 2).toUpperCase()));
            }
            return new Measure(value, Unit.PX);
        }
        catch (RuntimeException e) {
            LOG.warn("Can't parse to any measure: '" + value + "'");
            return null;
        }
    }

    public static Measure valueOf(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Measure) {
            return Measure.valueOf((Measure)object);
        }
        if (object instanceof Number) {
            return Measure.valueOf((Number)object);
        }
        if (object instanceof String) {
            return Measure.valueOf((String)object);
        }
        return Measure.valueOf(object.toString());
    }

    public String serialize() {
        return "" + (this.i != null ? this.i : "") + (this.d != null ? this.d : "") + this.unit.getValue();
    }

    public String toString() {
        return this.serialize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measure measure = (Measure)o;
        if (this.d != null ? !this.d.equals(measure.d) : measure.d != null) {
            return false;
        }
        if (this.i != null ? !this.i.equals(measure.i) : measure.i != null) {
            return false;
        }
        return this.unit == measure.unit;
    }

    public int hashCode() {
        int result = this.d != null ? this.d.hashCode() : 0;
        result = 31 * result + (this.i != null ? this.i.hashCode() : 0);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    private static enum Unit {
        EM,
        PX,
        EX,
        PT,
        CM,
        MM,
        IN,
        PC,
        PERCENT;

        private final String value = this.name().equals("PERCENT") ? "%" : this.name().toLowerCase();

        String getValue() {
            return this.value;
        }
    }
}

