/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ClientBehaviorRenderer;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RenderUtils.class);

    private RenderUtils() {
    }

    public static boolean contains(Object[] list, Object value) {
        if (list == null) {
            return false;
        }
        for (Object aList : list) {
            if (aList == null || !aList.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void encodeChildren(FacesContext facesContext, UIComponent panel) throws IOException {
        for (UIComponent child : panel.getChildren()) {
            RenderUtils.encode(facesContext, child);
        }
    }

    public static void encode(FacesContext facesContext, UIComponent component) throws IOException {
        RenderUtils.encode(facesContext, component, null);
    }

    public static void encode(FacesContext facesContext, UIComponent component, List<? extends Class<? extends UIComponent>> only) throws IOException {
        if (only != null && !RenderUtils.matchFilter(component, only)) {
            return;
        }
        if (component.isRendered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("rendering " + component.getRendererType() + " " + component);
            }
            component.encodeBegin(facesContext);
            if (component.getRendersChildren()) {
                component.encodeChildren(facesContext);
            } else {
                for (UIComponent child : component.getChildren()) {
                    RenderUtils.encode(facesContext, child, only);
                }
            }
            component.encodeEnd(facesContext);
        }
    }

    private static boolean matchFilter(UIComponent component, List<? extends Class<? extends UIComponent>> only) {
        for (Class<? extends UIComponent> clazz : only) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        return false;
    }

    public static String currentValue(UIComponent component) {
        String currentValue = null;
        if (component instanceof ValueHolder) {
            Object value;
            if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return (String)value;
            }
            value = ((ValueHolder)component).getValue();
            if (value != null) {
                currentValue = ComponentUtils.getFormattedValue(FacesContext.getCurrentInstance(), component, value);
            }
        }
        return currentValue;
    }

    public static void decodedStateOfTreeData(FacesContext facesContext, AbstractUIData data) {
        if (!data.isTreeModel()) {
            return;
        }
        List<Integer> selectedIndices = RenderUtils.decodeIndices(facesContext, data, "selected");
        List<Integer> expandedIndices = RenderUtils.decodeIndices(facesContext, data, "expanded");
        int last = data.isRowsUnlimited() ? Integer.MAX_VALUE : data.getFirst() + data.getRows();
        for (int rowIndex = data.getFirst(); rowIndex < last; ++rowIndex) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            boolean skip = false;
            for (UIComponent uiComponent : data.getChildren()) {
                if (!(uiComponent instanceof AbstractUITreeNodeBase) || uiComponent.isRendered()) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            TreePath path = data.getPath();
            if (selectedIndices != null) {
                SelectedState selectedState = data.getSelectedState();
                boolean oldSelected = selectedState.isSelected(path);
                boolean newSelected = selectedIndices.contains(rowIndex);
                if (newSelected != oldSelected) {
                    if (newSelected) {
                        selectedState.select(path);
                    } else {
                        selectedState.unselect(path);
                    }
                }
            }
            if (expandedIndices == null) continue;
            ExpandedState expandedState = data.getExpandedState();
            boolean oldExpanded = expandedState.isExpanded(path);
            boolean newExpanded = expandedIndices.contains(rowIndex);
            if (newExpanded == oldExpanded) continue;
            if (newExpanded) {
                expandedState.expand(path);
                continue;
            }
            expandedState.collapse(path);
        }
        data.setRowIndex(-1);
    }

    private static List<Integer> decodeIndices(FacesContext facesContext, AbstractUIData data, String suffix) {
        String string = null;
        String key = data.getClientId(facesContext) + "::" + suffix;
        try {
            string = (String)facesContext.getExternalContext().getRequestParameterMap().get(key);
            if (string != null) {
                return StringUtils.parseIntegerList(string);
            }
        }
        catch (Exception e) {
            LOG.warn("Can't parse " + suffix + ": '" + string + "' from parameter '" + key + "'", (Throwable)e);
        }
        return null;
    }

    public static String generateUrl(FacesContext facesContext, AbstractUICommandBase component) {
        String url = null;
        if (component.getLink() != null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            String link = component.getLink();
            if (link.startsWith("/")) {
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                try {
                    url = viewHandler.getBookmarkableURL(facesContext, link, null, true);
                }
                catch (Exception e) {
                    LOG.error("Link can't be resolved correctly! Please check existence, please also check there is no contextPath nor servlet mapping prefix like '/faces' is in the link. Link='" + link + "'", (Throwable)e);
                    url = link;
                }
            } else {
                url = StringUtils.isUrl(link) ? link : externalContext.encodeResourceURL(link);
            }
            StringBuilder builder = new StringBuilder(url);
            boolean firstParameter = !url.contains("?");
            for (UIComponent child : component.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                UIParameter parameter = (UIParameter)child;
                if (firstParameter) {
                    builder.append("?");
                    firstParameter = false;
                } else {
                    builder.append("&");
                }
                builder.append(parameter.getName());
                builder.append("=");
                Object value = parameter.getValue();
                if (value == null) continue;
                String characterEncoding = facesContext.getResponseWriter().getCharacterEncoding();
                try {
                    builder.append(URLEncoder.encode(value.toString(), characterEncoding));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            url = builder.toString();
        }
        return url;
    }

    public static CommandMap getBehaviorCommands(FacesContext facesContext, ClientBehaviorHolder holder) {
        CommandMap map = null;
        Map behaviors = holder.getClientBehaviors();
        for (Map.Entry behaviorMap : behaviors.entrySet()) {
            String key = (String)behaviorMap.getKey();
            ClientBehaviorContext context = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)((UIComponent)holder), (String)key, (String)((UIComponent)holder).getClientId(facesContext), null);
            for (ClientBehavior clientBehavior : (List)behaviorMap.getValue()) {
                if (clientBehavior instanceof ClientBehaviorBase) {
                    String type = ((ClientBehaviorBase)clientBehavior).getRendererType();
                    ClientBehaviorRenderer renderer = facesContext.getRenderKit().getClientBehaviorRenderer(type);
                    String dummy = renderer.getScript(context, clientBehavior);
                    map = CommandMap.merge(map, CommandMap.restoreCommandMap(facesContext));
                    continue;
                }
                LOG.warn("Ignoring: '{}'", (Object)clientBehavior);
            }
        }
        if ((map == null || map.isEmpty()) && holder instanceof AbstractUICommand) {
            if (map == null) {
                map = new CommandMap();
            }
            map.addCommand(ClientBehaviors.click, new Command(facesContext, (AbstractUICommand)holder));
        }
        return map;
    }

    public static void decodeClientBehaviors(FacesContext facesContext, UIComponent component) {
        List clientBehaviorList;
        Map paramMap;
        String behaviorEventName;
        ClientBehaviorHolder clientBehaviorHolder;
        Map clientBehaviors;
        if (component instanceof ClientBehaviorHolder && (clientBehaviors = (clientBehaviorHolder = (ClientBehaviorHolder)component).getClientBehaviors()) != null && !clientBehaviors.isEmpty() && (behaviorEventName = (String)(paramMap = facesContext.getExternalContext().getRequestParameterMap()).get("javax.faces.behavior.event")) != null && (clientBehaviorList = (List)clientBehaviors.get(behaviorEventName)) != null && !clientBehaviorList.isEmpty()) {
            String clientId = (String)paramMap.get("javax.faces.source");
            if (component.getClientId(facesContext).equals(clientId)) {
                for (ClientBehavior clientBehavior : clientBehaviorList) {
                    clientBehavior.decode(facesContext, component);
                }
            }
        }
    }
}

