/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.internal.context.DateTimeI18n;
import org.apache.myfaces.tobago.internal.renderkit.Collapse;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.layout.AutoLayoutToken;
import org.apache.myfaces.tobago.layout.LayoutToken;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.layout.MeasureLayoutToken;
import org.apache.myfaces.tobago.layout.RelativeLayoutToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);

    private JsonUtils() {
    }

    private static void encode(StringBuilder builder, String name, String[] value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        JsonUtils.encode(builder, value);
        builder.append(",");
    }

    public static void encode(StringBuilder builder, String[] value) {
        builder.append("[");
        boolean colon = false;
        for (String item : value) {
            if (colon) {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(item);
            builder.append("\"");
            colon = true;
        }
        builder.append("]");
    }

    public static void encode(StringBuilder builder, List<Integer> value) {
        builder.append("[");
        boolean colon = false;
        for (Integer item : value) {
            if (colon) {
                builder.append(",");
            }
            builder.append(item);
            colon = true;
        }
        builder.append("]");
    }

    private static void encode(StringBuilder builder, String name, Boolean value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(Boolean.toString(value));
        builder.append(",");
    }

    private static void encode(StringBuilder builder, String name, Integer value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(Integer.toString(value));
        builder.append(",");
    }

    private static void encode(StringBuilder builder, String name, String value) {
        value = value.replaceAll("\\\"", "\\\\\\\"");
        builder.append("\"");
        builder.append(name);
        builder.append("\":\"");
        builder.append(value);
        builder.append("\",");
    }

    public static String encode(CommandMap commandMap) {
        Map<ClientBehaviors, Command> other;
        if (commandMap == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int initialLength = builder.length();
        Command click = commandMap.getClick();
        if (click != null) {
            JsonUtils.encode(builder, ClientBehaviors.click, click);
        }
        if ((other = commandMap.getOther()) != null) {
            for (Map.Entry<ClientBehaviors, Command> entry : other.entrySet()) {
                JsonUtils.encode(builder, entry.getKey(), entry.getValue());
            }
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    private static void encode(StringBuilder builder, ClientBehaviors name, Command command) {
        Boolean omit;
        Integer delay;
        String confirmation;
        String focus;
        Collapse collapse;
        String render;
        String execute;
        String target;
        Boolean transition;
        builder.append("\"");
        builder.append((Object)name);
        builder.append("\":{");
        int initialLength = builder.length();
        String action = command.getAction();
        if (action != null) {
            JsonUtils.encode(builder, "action", action);
        }
        if ((transition = command.getTransition()) != null && !transition.booleanValue()) {
            JsonUtils.encode(builder, "transition", transition);
        }
        if ((target = command.getTarget()) != null) {
            JsonUtils.encode(builder, "target", target);
        }
        if ((execute = command.getExecute()) != null) {
            JsonUtils.encode(builder, "execute", execute);
        }
        if ((render = command.getRender()) != null) {
            JsonUtils.encode(builder, "render", render);
        }
        if ((collapse = command.getCollapse()) != null) {
            JsonUtils.encode(builder, "collapse", collapse);
        }
        if ((focus = command.getFocus()) != null) {
            JsonUtils.encode(builder, "focus", focus);
        }
        if ((confirmation = command.getConfirmation()) != null) {
            JsonUtils.encode(builder, "confirmation", confirmation);
        }
        if ((delay = command.getDelay()) != null) {
            JsonUtils.encode(builder, "delay", delay);
        }
        if ((omit = command.getOmit()) != null && omit.booleanValue()) {
            JsonUtils.encode(builder, "omit", true);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    private static void encode(StringBuilder builder, String name, Collapse collapse) {
        String forId;
        builder.append("\"");
        builder.append(name);
        builder.append("\":{");
        int initialLength = builder.length();
        Collapse.Action action = collapse.getAction();
        if (action != null) {
            JsonUtils.encode(builder, "transition", action.name());
        }
        if ((forId = collapse.getFor()) != null) {
            JsonUtils.encode(builder, "forId", forId);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    public static String encode(DateTimeI18n dateTimeI18n) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int initialLength = builder.length();
        JsonUtils.encode(builder, "monthNames", dateTimeI18n.getMonthNames());
        JsonUtils.encode(builder, "monthNamesShort", dateTimeI18n.getMonthNamesShort());
        JsonUtils.encode(builder, "dayNames", dateTimeI18n.getDayNames());
        JsonUtils.encode(builder, "dayNamesShort", dateTimeI18n.getDayNamesShort());
        JsonUtils.encode(builder, "dayNamesMin", dateTimeI18n.getDayNamesMin());
        JsonUtils.encode(builder, "firstDay", dateTimeI18n.getFirstDay());
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    public static String encode(String[] strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, strings);
        return builder.toString();
    }

    public static String encode(List<Integer> integers) {
        if (integers == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, integers);
        return builder.toString();
    }

    public static void encode(LayoutTokens bankHeads, StringBuilder builder) {
        builder.append("[");
        for (LayoutToken token : bankHeads.getTokens()) {
            if (token instanceof RelativeLayoutToken) {
                int factor = ((RelativeLayoutToken)token).getFactor();
                builder.append(factor);
            } else if (token instanceof AutoLayoutToken) {
                builder.append("\"auto\"");
            } else if (token instanceof MeasureLayoutToken) {
                builder.append("{\"measure\":\"");
                builder.append(((MeasureLayoutToken)token).getMeasure());
                builder.append("\"}");
            } else {
                LOG.warn("Not supported: " + token);
            }
            builder.append(',');
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]");
    }

    public static List<Integer> decodeIntegerArray(String json) {
        json = json.trim();
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (json.length() < 2 || json.charAt(0) != '[' || json.charAt(json.length() - 1) != ']') {
            LOG.warn("Can't parse JSON array: no surrounding square brackets []: '{}'", (Object)json);
        } else {
            json = json.substring(1, json.length() - 1);
            StringTokenizer tokenizer = new StringTokenizer(json, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                try {
                    result.add(Integer.parseInt(token));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Can't parse JSON array: not an integer token: '{}'", (Object)token);
                }
            }
        }
        return result;
    }
}

