/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBean
@ApplicationScoped
public class AuthorizationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationHelper.class);
    public static final String AUTHORIZATION_HELPER = "authorizationHelper";
    private static final Pattern PATTERN = Pattern.compile("#\\{(\\w+(?:\\.\\w+)*)\\.(\\w+)(?:\\(.*\\))?\\}");
    private static final Annotation NULL_VALUE = new Annotation(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }

        @Override
        public String toString() {
            return "(NULL)";
        }
    };
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private BeanManager beanManager;

    public AuthorizationHelper() {
        try {
            InitialContext context = new InitialContext();
            this.beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        }
        catch (Exception exception) {
            LOG.warn("Can't obtain 'java:comp/BeanManager'", (Throwable)exception);
        }
        if (this.beanManager == null) {
            this.beanManager = (BeanManager)FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().get(BeanManager.class.getName());
        }
        LOG.info("Using bean manager: '{}'", (Object)this.beanManager);
    }

    public static AuthorizationHelper getInstance(FacesContext facesContext) {
        return (AuthorizationHelper)facesContext.getELContext().getELResolver().getValue(facesContext.getELContext(), null, (Object)AUTHORIZATION_HELPER);
    }

    public boolean isAuthorized(FacesContext facesContext, String expression) {
        Annotation securityAnnotation = this.getSecurityAnnotation(facesContext, expression);
        if (securityAnnotation == null) {
            return true;
        }
        if (securityAnnotation instanceof DenyAll) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DenyAll");
            }
            return false;
        }
        if (securityAnnotation instanceof RolesAllowed) {
            String[] roles = ((RolesAllowed)securityAnnotation).value();
            if (LOG.isDebugEnabled()) {
                LOG.debug("RolesAllowed " + Arrays.asList(((RolesAllowed)securityAnnotation).value()));
            }
            for (String role : roles) {
                boolean authorised = facesContext.getExternalContext().isUserInRole(role);
                if (!authorised) continue;
                return true;
            }
            return false;
        }
        if (securityAnnotation instanceof PermitAll) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PermitAll");
            }
            return true;
        }
        return true;
    }

    private Annotation getSecurityAnnotation(FacesContext facesContext, String expression) {
        if (this.cache.containsKey(expression)) {
            Object obj = this.cache.get(expression);
            if (obj instanceof Annotation) {
                return (Annotation)obj;
            }
            return null;
        }
        Annotation securityAnnotation = null;
        Matcher matcher = PATTERN.matcher(expression);
        if (matcher.matches()) {
            String beanString = matcher.group(1);
            String methodString = matcher.group(2);
            Object bean = null;
            if (this.beanManager != null) {
                for (Bean entry : this.beanManager.getBeans(beanString)) {
                    if (bean == null) {
                        bean = entry;
                        continue;
                    }
                    LOG.warn("Bean name ambiguous: '{}'", (Object)beanString);
                }
            } else {
                bean = facesContext.getELContext().getELResolver().getValue(facesContext.getELContext(), null, (Object)beanString);
            }
            if (bean != null) {
                List<Method> methods = this.findMethods(bean, methodString);
                switch (methods.size()) {
                    case 0: {
                        LOG.error("No Method '" + methodString + "' in class " + bean.getClass());
                        break;
                    }
                    case 1: {
                        securityAnnotation = this.getSecurityAnnotations(methods.get(0));
                        break;
                    }
                    default: {
                        LOG.warn("Method name ambiguous '" + methodString + "' in class " + bean.getClass() + ". Found " + methods.size() + " but only 1 is supported, yet.");
                    }
                }
                if (securityAnnotation == null) {
                    securityAnnotation = this.getSecurityAnnotations(bean.getClass());
                }
            }
        }
        if (securityAnnotation == null) {
            securityAnnotation = NULL_VALUE;
        }
        this.cache.put(expression, securityAnnotation);
        if (LOG.isInfoEnabled()) {
            LOG.info("Security annotation '{}' saved for expression '{}'", (Object)securityAnnotation, (Object)expression);
        }
        return securityAnnotation;
    }

    private Annotation getSecurityAnnotations(AnnotatedElement annotatedElement) {
        RolesAllowed annotation = annotatedElement.getAnnotation(RolesAllowed.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = annotatedElement.getAnnotation(DenyAll.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = annotatedElement.getAnnotation(PermitAll.class);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }

    private List<Method> findMethods(Object bean, String name) {
        Class clazz = bean instanceof Bean ? ((Bean)bean).getBeanClass() : bean.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(name)) continue;
            result.add(method);
        }
        return result;
    }
}

