/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.component.UITreeSelect;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeMenu;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNodeRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeNodeRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        UITreeNode node = (UITreeNode)component;
        super.decode(facesContext, (UIComponent)node);
        if (ComponentUtils.isOutputOnly((UIComponent)node)) {
            return;
        }
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        if (data instanceof AbstractUITreeListbox) {
            String marked;
            String searchString;
            String clientId = data.getClientId(facesContext);
            String nodeStateId = node.nodeStateId(facesContext);
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            String id = node.getClientId(facesContext);
            boolean folder = node.isFolder();
            if (folder) {
                boolean bl = Boolean.parseBoolean((String)requestParameterMap.get(id + "-expanded"));
            }
            if (data.getSelectable() != Selectable.none) {
                String selected = (String)requestParameterMap.get(clientId + "-selectState");
                searchString = ";" + node.getClientId(facesContext) + ";";
                UITreeSelect treeSelect = ComponentUtils.findDescendant((UIComponent)node, UITreeSelect.class);
                if (treeSelect != null) {
                    treeSelect.setSubmittedValue(selected.contains(searchString));
                }
            }
            if ((marked = (String)requestParameterMap.get(clientId + "::" + "marked")) != null) {
                searchString = clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + nodeStateId;
                boolean bl = marked.equals(searchString);
            } else {
                LOG.warn("This log message is help clarifying the occurrence of this else case.");
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITreeNodeBase node = (AbstractUITreeNodeBase)component;
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        boolean dataRendersRowContainer = data.isRendersRowContainer();
        String clientId = node.getClientId(facesContext);
        String parentId = data.getRowParentClientId();
        boolean visible = data.isRowVisible();
        boolean folder = node.isFolder();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (data instanceof AbstractUITreeListbox) {
            writer.startElement(HtmlElements.OPTION);
            writer.writeAttribute(HtmlAttributes.VALUE, clientId, true);
            writer.writeIdAttribute(clientId);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SELECTED, folder);
        } else {
            Style style;
            writer.startElement(HtmlElements.DIV);
            writer.writeIdAttribute(clientId);
            Markup markup = Markup.NULL;
            if (data instanceof AbstractUITree && data.getSelectedState().isSelected(node.getPath())) {
                markup = markup.add(Markup.SELECTED);
            }
            if (folder) {
                markup = markup.add(Markup.FOLDER);
                if (data.getExpandedState().isExpanded(node.getPath())) {
                    markup = markup.add(Markup.EXPANDED);
                }
            }
            writer.writeClassAttribute(Classes.create((UIComponent)node, markup));
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)node);
            if (parentId != null) {
                writer.writeAttribute(DataAttributes.TREE_PARENT, parentId, false);
            }
            if ((style = node.getStyle()) == null) {
                style = new Style();
            }
            if (!dataRendersRowContainer && !visible) {
                style.setDisplay(Display.none);
            }
            if (style.getLeft() == null) {
                style.setMarginLeft(this.leftOffset(data, node.getLevel(), data.isShowRoot()));
            }
            writer.writeStyleAttribute(style);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITreeNodeBase node = (AbstractUITreeNodeBase)component;
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        int level = node.getLevel();
        boolean folder = node.isFolder();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath()) || level == 0;
        boolean isMenu = data instanceof AbstractUITreeMenu;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (data instanceof AbstractUITreeListbox) {
            if (folder) {
                writer.writeText(" \u2192");
            }
            writer.endElement(HtmlElements.OPTION);
        } else {
            if (isMenu && folder) {
                this.encodeIcon(facesContext, writer, expanded, node);
            }
            writer.endElement(HtmlElements.DIV);
        }
    }

    private void encodeIcon(FacesContext facesContext, TobagoResponseWriter writer, boolean expanded, AbstractUITreeNodeBase node) throws IOException {
    }

    protected Measure leftOffset(AbstractUIData data, int level, boolean showRoot) {
        if (data instanceof AbstractUITreeMenu) {
            int factor = showRoot ? level : level - 1;
            return Measure.valueOf(factor * 25);
        }
        return Measure.ZERO;
    }
}

