/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeLabel;
import org.apache.myfaces.tobago.component.UITreeListbox;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.component.UITreeSelect;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeListboxRenderer
extends RendererBase {
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeListbox tree = (UITreeListbox)component;
        String clientId = tree.getClientId(facesContext);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(Classes.create((UIComponent)tree));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)tree);
        writer.writeStyleAttribute(tree.getStyle());
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(HtmlAttributes.VALUE, ";", false);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(clientId + "::" + "marked");
        writer.writeIdAttribute(clientId + "::" + "marked");
        writer.writeAttribute(HtmlAttributes.VALUE, "", false);
        writer.endElement(HtmlElements.INPUT);
        if (tree.getSelectable().isSupportedByTreeListbox()) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            writer.writeNameAttribute(clientId + "-selectState");
            writer.writeIdAttribute(clientId + "-selectState");
            writer.writeAttribute(HtmlAttributes.VALUE, ";", false);
            writer.writeAttribute(DataAttributes.SELECTION_MODE, tree.getSelectable().name(), false);
            writer.endElement(HtmlElements.INPUT);
        }
        ArrayList<Integer> thisLevel = new ArrayList<Integer>();
        thisLevel.add(0);
        ArrayList<Integer> nextLevel = new ArrayList<Integer>();
        Integer size = tree.getSize();
        size = Math.max(size != null ? size : 10, 2);
        int depth = tree.getTreeDataModel().getDepth() != -1 ? tree.getTreeDataModel().getDepth() : 7;
        for (int level = 0; level < depth; ++level) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(Classes.create((UIComponent)tree, "level"));
            if (level > 0) {
                writer.startElement(HtmlElements.SELECT);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
                writer.writeClassAttribute(Classes.create((UIComponent)tree, "select"));
                writer.endElement(HtmlElements.SELECT);
            }
            for (Integer rowIndex : thisLevel) {
                this.encodeSelectBox(facesContext, tree, writer, rowIndex, nextLevel, size);
            }
            thisLevel.clear();
            ArrayList<Integer> swap = thisLevel;
            thisLevel = nextLevel;
            nextLevel = swap;
            writer.endElement(HtmlElements.DIV);
        }
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        tree.setRowIndex(-1);
    }

    private void encodeSelectBox(FacesContext facesContext, AbstractUITreeListbox tree, TobagoResponseWriter writer, int parentRowIndex, List<Integer> foldersRowIndices, int size) throws IOException {
        UITreeLabel label;
        tree.setRowIndex(parentRowIndex);
        UITreeNode node = ComponentUtils.findDescendant((UIComponent)tree, UITreeNode.class);
        String parentId = node.getClientId(facesContext);
        writer.startElement(HtmlElements.SELECT);
        writer.writeClassAttribute(Classes.create((UIComponent)tree, "select"));
        if (parentId != null) {
            writer.writeAttribute(DataAttributes.TREE_PARENT, parentId, false);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        UITreeSelect select = ComponentUtils.findDescendant((UIComponent)tree, UITreeSelect.class);
        String labelValue = select != null ? select.getLabel() : ((label = ComponentUtils.findDescendant((UIComponent)tree, UITreeLabel.class)) != null ? label.getLabel() : null);
        if (labelValue != null) {
            writer.startElement(HtmlElements.OPTGROUP);
            writer.writeAttribute(HtmlAttributes.LABEL, labelValue, true);
            writer.endElement(HtmlElements.OPTGROUP);
        }
        List<Integer> rowIndices = tree.getRowIndicesOfChildren();
        for (Integer rowIndex : rowIndices) {
            tree.setRowIndex(rowIndex);
            if (!tree.isRowAvailable()) break;
            for (UIComponent child : tree.getChildren()) {
                RenderUtils.encode(facesContext, child);
            }
            if (!tree.isFolder()) continue;
            foldersRowIndices.add(rowIndex);
        }
        writer.endElement(HtmlElements.SELECT);
    }
}

