/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeLabel;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLabelRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeLabelRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        boolean listbox = data instanceof AbstractUITreeListbox;
        UITreeLabel label = (UITreeLabel)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String text = StringUtils.defaultString((String)label.getValue());
        if (listbox) {
            writer.writeText(text);
        } else {
            writer.startElement(HtmlElements.LABEL);
            writer.writeClassAttribute(Classes.create((UIComponent)label));
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)label);
            writer.writeStyleAttribute(label.getStyle());
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)label);
            if (title != null) {
                writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            }
            writer.writeText(text);
            writer.endElement(HtmlElements.LABEL);
        }
    }
}

