/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeIndent;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.FontAwesomeIconEncoder;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeIndentRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        int i;
        UITreeIndent indent = (UITreeIndent)component;
        AbstractUITreeNodeBase node = ComponentUtils.findAncestor((UIComponent)indent, AbstractUITreeNodeBase.class);
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)indent, AbstractUIData.class);
        boolean folder = node.isFolder();
        int level = node.getLevel();
        List<Boolean> junctions = node.getJunctions();
        boolean showRoot = data.isShowRoot();
        boolean showJunctions = indent.isShowJunctions();
        boolean showRootJunction = data.isShowRootJunction();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath());
        boolean showLines = showJunctions && data instanceof UITree;
        boolean showIcons = showJunctions;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(indent.getClientId(facesContext));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)indent);
        writer.writeClassAttribute(TobagoClass.TREE_NODE__TOGGLE);
        boolean dropFirst = !showRoot || !showRootJunction && (showLines || showIcons);
        int n = i = dropFirst ? 1 : 0;
        while (i < junctions.size() - 1) {
            writer.writeIcon(Icons.SQUARE_O, BootstrapClass.INVISIBLE);
            ++i;
        }
        if (!showIcons || !showRootJunction && level == 0) {
            return;
        }
        Icons icon = folder ? (expanded ? Icons.MINUS_SQUARE_O : Icons.PLUS_SQUARE_O) : Icons.SQUARE_O;
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(FontAwesomeIconEncoder.FA, FontAwesomeIconEncoder.generateClass(icon));
        if (folder) {
            writer.writeAttribute(DataAttributes.SRC_OPEN, FontAwesomeIconEncoder.generateClass(Icons.MINUS_SQUARE_O).getName(), false);
            writer.writeAttribute(DataAttributes.SRC_CLOSED, FontAwesomeIconEncoder.generateClass(Icons.PLUS_SQUARE_O).getName(), false);
        }
        writer.endElement(HtmlElements.I);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SPAN);
    }
}

