/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUISuggest;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.model.AutoSuggestItem;
import org.apache.myfaces.tobago.model.AutoSuggestItems;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SuggestRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        AbstractUISuggest suggest = (AbstractUISuggest)component;
        String clientId = suggest.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            AbstractUIInput input;
            String query = (String)requestParameterMap.get(clientId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("suggest query='{}'", (Object)query);
            }
            if ((input = ComponentUtils.findAncestor((UIComponent)suggest, AbstractUIInput.class)) != null) {
                input.setSubmittedValue(query);
            }
            suggest.setQuery(query);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String[] array;
        AbstractUISuggest suggest = (AbstractUISuggest)component;
        AbstractUIInput input = ComponentUtils.findAncestor((UIComponent)suggest, AbstractUIInput.class);
        MethodExpression suggestMethodExpression = suggest.getSuggestMethodExpression();
        int totalCount = suggest.getTotalCount();
        if (suggestMethodExpression != null && input != null) {
            AutoSuggestItems autoSuggestItems = this.createAutoSuggestItems(suggestMethodExpression.invoke(facesContext.getELContext(), new Object[]{input}));
            List<AutoSuggestItem> items = autoSuggestItems.getItems();
            if (totalCount == -1 || items.size() < totalCount) {
                totalCount = items.size();
            }
            array = new String[totalCount];
            for (int i = 0; i < totalCount; ++i) {
                array[i] = items.get(i).getLabel();
            }
        } else {
            List<SelectItem> items = SelectItemUtils.getItemList(facesContext, (UIComponent)suggest);
            if (totalCount == -1 || items.size() < totalCount) {
                totalCount = items.size();
            }
            array = new String[totalCount];
            for (int i = 0; i < totalCount; ++i) {
                array[i] = items.get(i).getLabel();
            }
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeClassAttribute(TobagoClass.SUGGEST);
        String clientId = suggest.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        writer.writeNameAttribute(clientId);
        if (input != null) {
            writer.writeAttribute(DataAttributes.SUGGEST_FOR, input.getFieldId(facesContext), false);
        } else {
            LOG.error("No ancestor with type AbstractUIInput found for suggest id={}", (Object)clientId);
        }
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.SUGGEST_MIN_CHARS, suggest.getMinimumCharacters());
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.SUGGEST_DELAY, suggest.getDelay());
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.SUGGEST_MAX_ITEMS, suggest.getMaximumItems());
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.SUGGEST_UPDATE, suggest.isUpdate());
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.SUGGEST_TOTAL_COUNT, totalCount);
        writer.writeAttribute(DataAttributes.SUGGEST_DATA, JsonUtils.encode(array), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("suggest list: " + JsonUtils.encode(array));
        }
        writer.endElement(HtmlElements.INPUT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AutoSuggestItems createAutoSuggestItems(Object object) {
        if (object instanceof AutoSuggestItems) {
            return (AutoSuggestItems)object;
        }
        AutoSuggestItems autoSuggestItems = new AutoSuggestItems();
        if (object instanceof List && !((List)object).isEmpty()) {
            if (((List)object).get(0) instanceof AutoSuggestItem) {
                autoSuggestItems.setItems((List)object);
                return autoSuggestItems;
            } else {
                if (!(((List)object).get(0) instanceof String)) throw new ClassCastException("Can't create AutoSuggestItems from '" + object + "'. Elements needs to be " + String.class.getName() + " or " + AutoSuggestItem.class.getName());
                ArrayList<AutoSuggestItem> items = new ArrayList<AutoSuggestItem>(((List)object).size());
                for (int i = 0; i < ((List)object).size(); ++i) {
                    AutoSuggestItem item = new AutoSuggestItem();
                    item.setLabel((String)((List)object).get(i));
                    item.setValue((String)((List)object).get(i));
                    items.add(item);
                }
                autoSuggestItems.setItems(items);
            }
            return autoSuggestItems;
        } else {
            autoSuggestItems.setItems(Collections.<AutoSuggestItem>emptyList());
        }
        return autoSuggestItems;
    }
}

