/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.apache.myfaces.tobago.component.UIStyle;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class StyleRenderer
extends RendererBase
implements ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(StyleRenderer.class);

    public void processEvent(ComponentSystemEvent event) {
        CustomClass customClass;
        Style style;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIStyle styleComponent = (UIStyle)event.getComponent();
        String file = styleComponent.getFile();
        if (file != null) {
            FacesContextUtils.addStyleFile(facesContext, file);
        }
        if (!(style = new Style(styleComponent)).isEmpty()) {
            UIComponent parent = styleComponent.getParent();
            if (parent instanceof Visual) {
                ((Visual)parent).setStyle(style);
            } else {
                LOG.warn("The parent of a style component doesn't support style: " + parent.getClientId(facesContext));
            }
        }
        if ((customClass = styleComponent.getCustomClass()) != null) {
            UIComponent parent = styleComponent.getParent();
            if (parent instanceof Visual) {
                ((Visual)parent).setCustomClass(customClass);
            } else {
                LOG.warn("The parent of a style component doesn't support style: " + parent.getClientId(facesContext));
            }
        }
    }
}

