/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UILink;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.component.UISheet;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.component.AbstractUIRow;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.ShowPosition;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SheetRenderer.class);
    private static final String SUFFIX_WIDTHS = "::widths";
    private static final String SUFFIX_COLUMN_RENDERED = "::rendered";
    private static final String SUFFIX_SCROLL_POSITION = "::scrollPosition";
    private static final String SUFFIX_SELECTED = "::selected";

    public void decode(FacesContext facesContext, UIComponent component) {
        String value;
        UISheet sheet = (UISheet)component;
        List<AbstractUIColumnBase> columns = sheet.getAllColumns();
        String clientId = sheet.getClientId(facesContext);
        String key = clientId + SUFFIX_WIDTHS;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        SheetState state = sheet.getState();
        if (requestParameterMap.containsKey(key)) {
            String widths = (String)requestParameterMap.get(key);
            this.ensureColumnWidthsSize(state.getColumnWidths(), columns, JsonUtils.decodeIntegerArray(widths));
        }
        if (requestParameterMap.containsKey(key = clientId + SUFFIX_SELECTED)) {
            List<Integer> selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected = " + selected);
            }
            try {
                selectedRows = StringUtils.parseIntegerList(selected);
            }
            catch (NumberFormatException e) {
                LOG.warn(selected, (Throwable)e);
                selectedRows = Collections.emptyList();
            }
            ComponentUtils.setAttribute((UIComponent)sheet, Attributes.selectedListString, selectedRows);
        }
        if ((value = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + SUFFIX_SCROLL_POSITION)) != null) {
            state.getScrollPosition().update(value);
        }
        RenderUtils.decodedStateOfTreeData(facesContext, sheet);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UISheet sheet = (UISheet)component;
        String sheetId = sheet.getClientId(facesContext);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent header = sheet.getHeader();
        if (header == null) {
            header = ComponentUtils.createComponent(facesContext, "org.apache.myfaces.tobago.Panel", null, "_header");
            List<AbstractUIColumnBase> columns = sheet.getAllColumns();
            int i = 0;
            for (AbstractUIColumnBase column : columns) {
                if (!(column instanceof AbstractUIRow)) {
                    AbstractUIOut out = (AbstractUIOut)ComponentUtils.createComponent(facesContext, "org.apache.myfaces.tobago.Out", RendererTypes.Out, "_col" + i);
                    ValueExpression valueExpression = column.getValueExpression(Attributes.label.getName());
                    if (valueExpression != null) {
                        out.setValueExpression(Attributes.value.getName(), valueExpression);
                    } else {
                        out.setValue(ComponentUtils.getAttribute((UIComponent)column, Attributes.label));
                    }
                    valueExpression = column.getValueExpression(Attributes.rendered.getName());
                    if (valueExpression != null) {
                        out.setValueExpression(Attributes.rendered.getName(), valueExpression);
                    } else {
                        out.setRendered(ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.rendered));
                    }
                    out.setLabelLayout(LabelLayout.skip);
                    header.getChildren().add(out);
                }
                ++i;
            }
            sheet.setHeader(header);
        }
        sheet.init(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(sheetId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)sheet);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet), sheet.getCustomClass());
        writer.writeStyleAttribute(sheet.getStyle());
        UIComponent facetReload = ComponentUtils.getFacet((UIComponent)sheet, Facets.reload);
        if (facetReload != null && facetReload instanceof UIReload && facetReload.isRendered()) {
            UIReload update = (UIReload)facetReload;
            writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.RELOAD, update.getFrequency());
        }
        CommandMap commands = RenderUtils.getBehaviorCommands(facesContext, sheet);
        writer.writeAttribute(DataAttributes.BEHAVIOR_COMMANDS, JsonUtils.encode(commands), false);
        writer.writeAttribute(DataAttributes.SELECTION_MODE, sheet.getSelectable().name(), false);
        writer.writeAttribute(DataAttributes.FIRST, Integer.toString(sheet.getFirst()), false);
        StringBuilder builder = new StringBuilder();
        boolean autoLayout = sheet.isAutoLayout();
        if (!autoLayout) {
            builder.append("{\"columns\":");
            JsonUtils.encode(sheet.getColumnLayout(), builder);
            builder.append("}");
            writer.writeAttribute(DataAttributes.LAYOUT, builder.toString(), true);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UISheet sheet = (UISheet)uiComponent;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String sheetId = sheet.getClientId(facesContext);
        Selectable selectable = sheet.getSelectable();
        Application application = facesContext.getApplication();
        SheetState state = sheet.getSheetState(facesContext);
        List<Integer> columnWidths = sheet.getState().getColumnWidths();
        boolean definedColumnWidths = sheet.getState().isDefinedColumnWidths();
        List<Integer> selectedRows = this.getSelectedRows(sheet, state);
        List<AbstractUIColumnBase> columns = sheet.getAllColumns();
        boolean showHeader = sheet.isShowHeader();
        boolean autoLayout = sheet.isAutoLayout();
        Markup sheetMarkup = sheet.getMarkup() != null ? sheet.getMarkup() : Markup.NULL;
        this.ensureColumnWidthsSize(columnWidths, columns, Collections.<Integer>emptyList());
        if (!autoLayout) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeIdAttribute(sheetId + SUFFIX_WIDTHS);
            writer.writeNameAttribute(sheetId + SUFFIX_WIDTHS);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            writer.writeAttribute(HtmlAttributes.VALUE, JsonUtils.encode(definedColumnWidths ? columnWidths : Collections.emptyList()), false);
            writer.endElement(HtmlElements.INPUT);
            writer.startElement(HtmlElements.INPUT);
            writer.writeIdAttribute(sheetId + SUFFIX_COLUMN_RENDERED);
            writer.writeNameAttribute(sheetId + SUFFIX_COLUMN_RENDERED);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            ArrayList<String> encodedRendered = new ArrayList<String>();
            for (AbstractUIColumnBase column : columns) {
                if (column instanceof AbstractUIRow) continue;
                encodedRendered.add(Boolean.toString(column.isRendered()));
            }
            writer.writeAttribute(HtmlAttributes.VALUE, JsonUtils.encode(encodedRendered.toArray(new String[encodedRendered.size()])), false);
            writer.endElement(HtmlElements.INPUT);
        }
        String clientId = sheet.getClientId(facesContext);
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(clientId + SUFFIX_SCROLL_POSITION);
        writer.writeNameAttribute(clientId + SUFFIX_SCROLL_POSITION);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, sheet.getState().getScrollPosition().encode(), false);
        writer.writeAttribute(DataAttributes.SCROLL_POSITION, Boolean.TRUE.toString(), true);
        writer.endElement(HtmlElements.INPUT);
        if (selectable != Selectable.none) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeIdAttribute(sheetId + SUFFIX_SELECTED);
            writer.writeNameAttribute(sheetId + SUFFIX_SELECTED);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            writer.writeAttribute(HtmlAttributes.VALUE, StringUtils.joinWithSurroundingSeparator(selectedRows), true);
            writer.endElement(HtmlElements.INPUT);
        }
        ExpandedState expandedState = null;
        StringBuilder expandedValue = null;
        if (sheet.isTreeModel()) {
            expandedState = sheet.getExpandedState();
            expandedValue = new StringBuilder(",");
        }
        if (showHeader && !autoLayout) {
            writer.startElement(HtmlElements.HEADER);
            writer.writeClassAttribute(TobagoClass.SHEET__HEADER);
            writer.startElement(HtmlElements.TABLE);
            writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
            writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
            writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
            writer.writeClassAttribute(BootstrapClass.TABLE, TobagoClass.SHEET__HEADER_TABLE, sheetMarkup.contains(Markup.INVERSE) ? BootstrapClass.TABLE_INVERSE : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, !autoLayout ? TobagoClass.TABLE_LAYOUT__FIXED : null);
            this.writeColgroup(writer, columnWidths, columns, true);
            writer.startElement(HtmlElements.TBODY);
            this.encodeHeaderRows(facesContext, sheet, writer, columns);
            writer.endElement(HtmlElements.TBODY);
            writer.endElement(HtmlElements.TABLE);
            writer.endElement(HtmlElements.HEADER);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(sheetId + "::" + "data_div");
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, "body"));
        writer.startElement(HtmlElements.TABLE);
        writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
        writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
        writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
        writer.writeClassAttribute(BootstrapClass.TABLE, TobagoClass.SHEET__BODY_TABLE, sheetMarkup.contains(Markup.INVERSE) ? BootstrapClass.TABLE_INVERSE : null, sheetMarkup.contains(Markup.STRIPED) ? BootstrapClass.TABLE_STRIPED : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.HOVER) ? BootstrapClass.TABLE_HOVER : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, !autoLayout ? TobagoClass.TABLE_LAYOUT__FIXED : null);
        if (showHeader && autoLayout) {
            writer.startElement(HtmlElements.THEAD);
            this.encodeHeaderRows(facesContext, sheet, writer, columns);
            writer.endElement(HtmlElements.THEAD);
        }
        if (!autoLayout) {
            this.writeColgroup(writer, columnWidths, columns, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("first = " + sheet.getFirst() + "   rows = " + sheet.getRows());
        }
        writer.startElement(HtmlElements.TBODY);
        String var = sheet.getVar();
        boolean emptySheet = true;
        int last = sheet.isRowsUnlimited() ? Integer.MAX_VALUE : sheet.getFirst() + sheet.getRows();
        for (int rowIndex = sheet.getFirst(); rowIndex < last; ++rowIndex) {
            String parentId;
            sheet.setRowIndex(rowIndex);
            if (!sheet.isRowAvailable()) break;
            Object v = sheet.getAttributes().get("rowRendered");
            if (v instanceof Boolean && !((Boolean)v).booleanValue()) continue;
            emptySheet = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("var       " + var);
                LOG.debug("list      " + sheet.getValue());
            }
            if (sheet.isTreeModel()) {
                TreePath path = sheet.getPath();
                if (sheet.isFolder() && expandedState.isExpanded(path)) {
                    expandedValue.append(rowIndex);
                    expandedValue.append(",");
                }
            }
            writer.startElement(HtmlElements.TR);
            if (v instanceof Boolean) {
                writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.ROW_INDEX, rowIndex);
            }
            boolean selected = selectedRows.contains(rowIndex);
            String[] rowMarkups = (String[])sheet.getAttributes().get("rowMarkup");
            Markup rowMarkup = Markup.NULL;
            if (selected) {
                rowMarkup = rowMarkup.add(Markup.SELECTED);
            }
            if (rowMarkups != null) {
                rowMarkup = rowMarkup.add(Markup.valueOf(rowMarkups));
            }
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, "row", rowMarkup), selected ? BootstrapClass.TABLE_INFO : null);
            if (!sheet.isRowVisible()) {
                Style rowStyle = new Style();
                rowStyle.setDisplay(Display.none);
                writer.writeStyleAttribute(rowStyle);
            }
            if ((parentId = sheet.getRowParentClientId()) != null) {
                writer.writeAttribute(DataAttributes.TREE_PARENT, parentId, false);
            }
            for (UIColumn uIColumn : columns) {
                if (!uIColumn.isRendered() || !(uIColumn instanceof AbstractUIRow)) continue;
                AbstractUIRow row = (AbstractUIRow)uIColumn;
                writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, row)));
                writer.writeIdAttribute(row.getClientId(facesContext));
            }
            for (UIColumn uIColumn : columns) {
                if (!uIColumn.isRendered() || !(uIColumn instanceof AbstractUIColumn)) continue;
                AbstractUIColumn normalColumn = (AbstractUIColumn)uIColumn;
                writer.startElement(HtmlElements.TD);
                Markup markup = normalColumn.getMarkup();
                if (markup == null) {
                    markup = Markup.NULL;
                }
                markup = markup.add(this.getMarkupForAlign(normalColumn));
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "cell", markup), normalColumn.getCustomClass());
                writer.writeStyleAttribute(normalColumn.getStyle());
                if (normalColumn instanceof UIColumnSelector) {
                    UIColumnSelector selector = (UIColumnSelector)normalColumn;
                    writer.startElement(HtmlElements.INPUT);
                    if (selectable.isSingle()) {
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                    } else {
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                    }
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, selected);
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, selector.isDisabled());
                    writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INLINE, TobagoClass.SHEET__COLUMN_SELECTOR);
                    writer.endElement(HtmlElements.INPUT);
                } else if (normalColumn instanceof AbstractUIColumnNode) {
                    RenderUtils.encode(facesContext, (UIComponent)normalColumn);
                } else {
                    List<UIComponent> children = sheet.getRenderedChildrenOf(normalColumn);
                    for (UIComponent grandKid : children) {
                        RenderUtils.encode(facesContext, grandKid);
                    }
                }
                writer.endElement(HtmlElements.TD);
            }
            if (!autoLayout) {
                writer.startElement(HtmlElements.TD);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "cell", Markup.FILLER));
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            writer.endElement(HtmlElements.TR);
        }
        sheet.setRowIndex(-1);
        if (emptySheet && showHeader) {
            writer.startElement(HtmlElements.TR);
            for (UIColumn uIColumn : columns) {
                if (uIColumn instanceof AbstractUIRow) continue;
                writer.startElement(HtmlElements.TD);
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            if (!autoLayout) {
                writer.startElement(HtmlElements.TD);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "cell", Markup.FILLER));
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            writer.endElement(HtmlElements.TR);
        }
        writer.endElement(HtmlElements.TBODY);
        writer.endElement(HtmlElements.TABLE);
        writer.endElement(HtmlElements.DIV);
        if (sheet.isPagingVisible()) {
            Markup showPageRange;
            Markup markup;
            writer.startElement(HtmlElements.FOOTER);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, "footer"));
            Markup showRowRange = this.markupForLeftCenterRight(sheet.getShowRowRange());
            if (showRowRange != Markup.NULL) {
                UILink uILink = this.ensurePagingCommand(application, sheet, Facets.pagerRow.name(), SheetAction.toRow, false);
                String pagerCommandId = uILink.getClientId(facesContext);
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "paging", showRowRange), BootstrapClass.PAGINATION);
                writer.startElement(HtmlElements.LI);
                writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
                writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "sheetPagingInfoRowPagingTip"), true);
                writer.startElement(HtmlElements.SPAN);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "pagingText"), BootstrapClass.PAGE_LINK);
                if (sheet.getRowCount() != 0) {
                    void var29_60;
                    boolean unknown;
                    Locale locale = facesContext.getViewRoot().getLocale();
                    int first = sheet.getFirst() + 1;
                    int last1 = sheet.hasRowCount() ? sheet.getLastRowIndexOfCurrentPage() : -1;
                    boolean bl = unknown = !sheet.hasRowCount();
                    if (unknown) {
                        if (first == last1) {
                            String string = "sheetPagingInfoUndefinedSingleRow";
                        } else {
                            String string = "sheetPagingInfoUndefinedRows";
                        }
                    } else if (first == last1) {
                        String string = "sheetPagingInfoSingleRow";
                    } else {
                        String string = "sheetPagingInfoRows";
                    }
                    String inputMarker = "{#}";
                    Object[] args = new Object[]{"{#}", last1 == -1 ? "?" : Integer.valueOf(last1), unknown ? "" : Integer.valueOf(sheet.getRowCount())};
                    MessageFormat detail = new MessageFormat(TobagoResourceBundle.getString(facesContext, (String)var29_60), locale);
                    String formatted = detail.format(args);
                    int pos = formatted.indexOf("{#}");
                    if (pos >= 0) {
                        writer.writeText(formatted.substring(0, pos));
                        writer.startElement(HtmlElements.SPAN);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_OUTPUT);
                        writer.writeText(Integer.toString(first));
                        writer.endElement(HtmlElements.SPAN);
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeIdAttribute(pagerCommandId);
                        writer.writeNameAttribute(pagerCommandId);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_INPUT);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                        if (!unknown) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, Integer.toString(sheet.getRowCount()).length());
                        }
                        writer.endElement(HtmlElements.INPUT);
                        writer.writeText(formatted.substring(pos + "{#}".length()));
                    } else {
                        writer.writeText(formatted);
                    }
                } else {
                    writer.write(TobagoResourceBundle.getString(facesContext, "sheetPagingInfoEmptyRow"));
                }
                writer.endElement(HtmlElements.SPAN);
                writer.endElement(HtmlElements.LI);
                writer.endElement(HtmlElements.UL);
            }
            if ((markup = this.markupForLeftCenterRight(sheet.getShowDirectLinks())) != Markup.NULL) {
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "paging", markup), BootstrapClass.PAGINATION);
                if (sheet.isShowDirectLinksArrows()) {
                    boolean disabled = sheet.isAtBeginning();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.first, null, Icons.STEP_BACKWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.prev, null, Icons.BACKWARD, null);
                }
                this.encodeDirectPagingLinks(facesContext, application, sheet);
                if (sheet.isShowDirectLinksArrows()) {
                    boolean disabled = sheet.isAtEnd();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.next, null, Icons.FORWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled || !sheet.hasRowCount(), SheetAction.last, null, Icons.STEP_FORWARD, null);
                }
                writer.endElement(HtmlElements.UL);
            }
            if ((showPageRange = this.markupForLeftCenterRight(sheet.getShowPageRange())) != Markup.NULL) {
                UILink command = this.ensurePagingCommand(application, sheet, Facets.pagerPage.name(), SheetAction.toPage, false);
                String pagerCommandId = command.getClientId(facesContext);
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "paging", showPageRange), BootstrapClass.PAGINATION);
                if (sheet.isShowPageRangeArrows()) {
                    boolean disabled = sheet.isAtBeginning();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.first, null, Icons.STEP_BACKWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.prev, null, Icons.BACKWARD, null);
                }
                writer.startElement(HtmlElements.LI);
                writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
                writer.startElement(HtmlElements.SPAN);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "pagingText"), BootstrapClass.PAGE_LINK);
                writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "sheetPagingInfoPagePagingTip"), true);
                if (sheet.getRowCount() != 0) {
                    int pages;
                    Locale locale = facesContext.getViewRoot().getLocale();
                    int first = sheet.getCurrentPage() + 1;
                    boolean bl = !sheet.hasRowCount();
                    int n = pages = bl ? -1 : sheet.getPages();
                    String key = bl ? (first == pages ? "sheetPagingInfoUndefinedSinglePage" : "sheetPagingInfoUndefinedPages") : (first == pages ? "sheetPagingInfoSinglePage" : "sheetPagingInfoPages");
                    String inputMarker = "{#}";
                    Object[] args = new Object[]{"{#}", pages == -1 ? "?" : Integer.valueOf(pages)};
                    MessageFormat detail = new MessageFormat(TobagoResourceBundle.getString(facesContext, key), locale);
                    String formatted = detail.format(args);
                    int pos = formatted.indexOf("{#}");
                    if (pos >= 0) {
                        writer.writeText(formatted.substring(0, pos));
                        writer.startElement(HtmlElements.SPAN);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_OUTPUT);
                        writer.writeText(Integer.toString(first));
                        writer.endElement(HtmlElements.SPAN);
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeIdAttribute(pagerCommandId);
                        writer.writeNameAttribute(pagerCommandId);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                        writer.writeClassAttribute(TobagoClass.SHEET__PAGING_INPUT);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                        if (!bl) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, Integer.toString(pages).length());
                        }
                        writer.endElement(HtmlElements.INPUT);
                        writer.writeText(formatted.substring(pos + "{#}".length()));
                    } else {
                        writer.writeText(formatted);
                    }
                } else {
                    writer.writeText(TobagoResourceBundle.getString(facesContext, "sheetPagingInfoEmptyPage"));
                }
                writer.endElement(HtmlElements.SPAN);
                writer.endElement(HtmlElements.LI);
                if (sheet.isShowPageRangeArrows()) {
                    boolean disabled = sheet.isAtEnd();
                    this.encodeLink(facesContext, sheet, application, disabled, SheetAction.next, null, Icons.FORWARD, null);
                    this.encodeLink(facesContext, sheet, application, disabled || !sheet.hasRowCount(), SheetAction.last, null, Icons.STEP_FORWARD, null);
                }
                writer.endElement(HtmlElements.UL);
            }
            writer.endElement(HtmlElements.FOOTER);
        }
        if (sheet.isTreeModel()) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            String expandedId = sheetId + "::" + "expanded";
            writer.writeNameAttribute(expandedId);
            writer.writeIdAttribute(expandedId);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, "expanded"));
            writer.writeAttribute(HtmlAttributes.VALUE, expandedValue.toString(), false);
            writer.endElement(HtmlElements.INPUT);
        }
        writer.endElement(HtmlElements.DIV);
    }

    private void ensureColumnWidthsSize(List<Integer> columnWidths, List<AbstractUIColumnBase> columns, List<Integer> samples) {
        int i = 0;
        int j = 0;
        for (AbstractUIColumnBase column : columns) {
            Integer newValue;
            if (column instanceof AbstractUIRow) continue;
            if (j < samples.size()) {
                newValue = samples.get(j);
                ++j;
            } else {
                newValue = null;
            }
            if (columnWidths.size() > i) {
                if (newValue != null) {
                    columnWidths.set(i, newValue);
                }
            } else {
                columnWidths.add(newValue != null ? newValue : -1);
            }
            ++i;
        }
    }

    private Markup getMarkupForAlign(UIColumn column) {
        String textAlign = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.align);
        if (textAlign != null) {
            switch (TextAlign.valueOf(textAlign)) {
                case right: {
                    return Markup.RIGHT;
                }
                case center: {
                    return Markup.CENTER;
                }
                case justify: {
                    return Markup.JUSTIFY;
                }
            }
        }
        return null;
    }

    private void encodeHeaderRows(FacesContext facesContext, UISheet sheet, TobagoResponseWriter writer, List<AbstractUIColumnBase> columns) throws IOException {
        Selectable selectable = sheet.getSelectable();
        Grid grid = sheet.getHeaderGrid();
        boolean autoLayout = sheet.isAutoLayout();
        boolean multiHeader = grid.getRowCount() > 1;
        int offset = 0;
        for (int i = 0; i < grid.getRowCount(); ++i) {
            writer.startElement(HtmlElements.TR);
            for (int j = 0; j < columns.size(); ++j) {
                boolean sortable;
                TobagoClass align;
                AbstractUIColumnBase column = columns.get(j);
                if (!column.isRendered() || column instanceof AbstractUIRow) {
                    ++offset;
                    continue;
                }
                Cell cell = grid.getCell(j - offset, i);
                if (!(cell instanceof OriginCell)) continue;
                writer.startElement(HtmlElements.TH);
                writer.writeClassAttribute(column.getCustomClass());
                writer.writeStyleAttribute(column.getStyle());
                if (cell.getColumnSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, cell.getColumnSpan());
                }
                if (cell.getRowSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWSPAN, cell.getRowSpan());
                }
                UIComponent cellComponent = cell.getComponent();
                String alignString = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.align);
                if (multiHeader && cell.getColumnSpan() > 1) {
                    align = TobagoClass.SHEET__CELL__MARKUP__CENTER;
                } else if (alignString != null) {
                    switch (TextAlign.valueOf(alignString)) {
                        case right: {
                            align = TobagoClass.SHEET__CELL__MARKUP__RIGHT;
                            break;
                        }
                        case center: {
                            align = TobagoClass.SHEET__CELL__MARKUP__CENTER;
                            break;
                        }
                        case justify: {
                            align = TobagoClass.SHEET__CELL__MARKUP__JUSTIFY;
                            break;
                        }
                        default: {
                            align = null;
                            break;
                        }
                    }
                } else {
                    align = null;
                }
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "headerCell"), align);
                writer.startElement(HtmlElements.SPAN);
                Icons sorterIcon = null;
                Markup markup = Markup.NULL;
                String tip = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.tip);
                if (cell.getColumnSpan() == 1 && cellComponent instanceof UIOut && (sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.sortable))) {
                    UILink sortCommand = (UILink)ComponentUtils.getFacet((UIComponent)column, Facets.sorter);
                    if (sortCommand == null) {
                        String columnId = column.getClientId(facesContext);
                        String sorterId = columnId.substring(columnId.lastIndexOf(":") + 1) + "_" + "sorter";
                        sortCommand = (UILink)ComponentUtils.createComponent(facesContext, "org.apache.myfaces.tobago.Link", RendererTypes.Link, sorterId);
                        AjaxBehavior reloadBehavior = this.createReloadBehavior(sheet);
                        sortCommand.addClientBehavior("click", (ClientBehavior)reloadBehavior);
                        sortCommand.setRendererType("SheetPageCommand");
                        ComponentUtils.setAttribute((UIComponent)sortCommand, Attributes.sheetAction, (Object)SheetAction.sort);
                        ComponentUtils.setFacet((UIComponent)column, Facets.sorter, (UIComponent)sortCommand);
                    }
                    writer.writeIdAttribute(sortCommand.getClientId(facesContext));
                    writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, sortCommand)));
                    tip = tip == null ? "" : tip + " - ";
                    tip = tip + TobagoResourceBundle.getString(facesContext, "sheetTipSorting");
                    markup = markup.add(Markup.SORTABLE);
                    SheetState sheetState = sheet.getSheetState(facesContext);
                    if (column.getId().equals(sheetState.getSortedColumnId())) {
                        String sortTitle;
                        if (sheetState.isAscending()) {
                            sorterIcon = Icons.ANGLE_UP;
                            sortTitle = TobagoResourceBundle.getString(facesContext, "sheetAscending");
                            markup = markup.add(Markup.ASCENDING);
                        } else {
                            sorterIcon = Icons.ANGLE_DOWN;
                            sortTitle = TobagoResourceBundle.getString(facesContext, "sheetDescending");
                            markup = markup.add(Markup.DESCENDING);
                        }
                        if (sortTitle != null) {
                            tip = tip + " - " + sortTitle;
                        }
                    }
                }
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, "header", markup));
                writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
                if (column instanceof UIColumnSelector && selectable.isMulti()) {
                    writer.startElement(HtmlElements.INPUT);
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                    writer.writeClassAttribute(TobagoClass.SHEET__COLUMN_SELECTOR);
                    writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "sheetMenuSelect"), true);
                    writer.endElement(HtmlElements.INPUT);
                } else {
                    RenderUtils.encode(facesContext, cellComponent);
                }
                if (sorterIcon != null) {
                    writer.writeIcon(sorterIcon, new CssItem[0]);
                }
                writer.endElement(HtmlElements.SPAN);
                if (!autoLayout && column.isResizable()) {
                    this.encodeResizing(writer, sheet, j - offset + cell.getColumnSpan() - 1);
                }
                writer.endElement(HtmlElements.TH);
            }
            if (!autoLayout) {
                this.encodeHeaderFiller(writer, sheet);
                this.encodeHeaderFiller(writer, sheet);
            }
            writer.endElement(HtmlElements.TR);
        }
    }

    private void encodeHeaderFiller(TobagoResponseWriter writer, UISheet sheet) throws IOException {
        writer.startElement(HtmlElements.TH);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, "headerCell", Markup.FILLER));
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, "header"));
        Style headerStyle = new Style();
        headerStyle.setHeight(Measure.valueOf(14));
        writer.writeStyleAttribute(headerStyle);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.TH);
    }

    private void writeColgroup(TobagoResponseWriter writer, List<Integer> columnWidths, List<AbstractUIColumnBase> columns, boolean isHeader) throws IOException {
        writer.startElement(HtmlElements.COLGROUP);
        int i = 0;
        for (AbstractUIColumnBase column : columns) {
            if (column instanceof AbstractUIRow) continue;
            if (column.isRendered()) {
                Integer width = columnWidths.get(i);
                this.writeCol(writer, width >= 0 ? width : null);
            }
            ++i;
        }
        this.writeCol(writer, null);
        if (isHeader) {
            this.writeCol(writer, null);
        }
        writer.endElement(HtmlElements.COLGROUP);
    }

    private void writeCol(TobagoResponseWriter writer, Integer columnWidth) throws IOException {
        writer.startElement(HtmlElements.COL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.WIDTH, columnWidth);
        writer.endElement(HtmlElements.COL);
    }

    private Markup markupForLeftCenterRight(ShowPosition position) {
        switch (position) {
            case left: {
                return Markup.LEFT;
            }
            case center: {
                return Markup.CENTER;
            }
            case right: {
                return Markup.RIGHT;
            }
        }
        return Markup.NULL;
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getSelectedRows(UISheet data, SheetState state) {
        List<Integer> selected = (List<Integer>)ComponentUtils.getAttribute((UIComponent)data, Attributes.selectedListString);
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.emptyList();
        }
        return selected;
    }

    private void encodeLink(FacesContext facesContext, UISheet data, Application application, boolean disabled, SheetAction action, Integer target, Icons icon, CssItem liClass) throws IOException {
        String facet = action == SheetAction.toPage || action == SheetAction.toRow ? action.name() + "-" + target : action.name();
        UILink command = this.ensurePagingCommand(application, data, facet, action, disabled);
        if (target != null) {
            ComponentUtils.setAttribute((UIComponent)command, Attributes.pagingTarget, target);
        }
        Locale locale = facesContext.getViewRoot().getLocale();
        String message = TobagoResourceBundle.getString(facesContext, action.getBundleKey());
        String tip = new MessageFormat(message, locale).format(new Integer[]{target});
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.LI);
        writer.writeClassAttribute(liClass, disabled ? BootstrapClass.DISABLED : null, BootstrapClass.PAGE_ITEM);
        writer.startElement(HtmlElements.A);
        writer.writeClassAttribute(BootstrapClass.PAGE_LINK);
        writer.writeAttribute(HtmlAttributes.HREF, "#/", false);
        writer.writeIdAttribute(command.getClientId(facesContext));
        writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        if (!disabled) {
            writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, command)));
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        if (icon != null) {
            writer.writeIcon(icon, new CssItem[0]);
        } else {
            writer.writeText(String.valueOf(target));
        }
        writer.endElement(HtmlElements.A);
        writer.endElement(HtmlElements.LI);
    }

    private void encodeResizing(TobagoResponseWriter writer, AbstractUISheet sheet, int columnIndex) throws IOException {
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, "headerResize"));
        writer.writeAttribute(DataAttributes.COLUMN_INDEX, Integer.toString(columnIndex), false);
        writer.write("&nbsp;&nbsp;");
        writer.endElement(HtmlElements.SPAN);
    }

    private void encodeDirectPagingLinks(FacesContext facesContext, Application application, UISheet sheet) throws IOException {
        int skip;
        UILink command = this.ensurePagingCommand(application, sheet, "pagerPageDirect", SheetAction.toPage, false);
        int linkCount = ComponentUtils.getIntAttribute((UIComponent)sheet, Attributes.directLinkCount);
        ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
        int page = sheet.getCurrentPage() + 1;
        for (int i = 0; i < linkCount && page > 1; ++i) {
            if (--page <= 0) continue;
            prevs.add(0, page);
        }
        ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
        page = sheet.getCurrentPage() + 1;
        int pages = sheet.hasRowCount() || sheet.isRowsUnlimited() ? sheet.getPages() : Integer.MAX_VALUE;
        for (int i = 0; i < linkCount && page < pages; ++i) {
            if (++page <= 1) continue;
            nexts.add(page);
        }
        if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
            while (prevs.size() > linkCount / 2) {
                prevs.remove(0);
            }
            while (nexts.size() > linkCount - linkCount / 2) {
                nexts.remove(nexts.size() - 1);
            }
        } else if (prevs.size() <= linkCount / 2) {
            while (prevs.size() + nexts.size() > linkCount) {
                nexts.remove(nexts.size() - 1);
            }
        } else {
            while (prevs.size() + nexts.size() > linkCount) {
                prevs.remove(0);
            }
        }
        int n = skip = prevs.size() > 0 ? (Integer)prevs.get(0) : 1;
        if (!sheet.isShowDirectLinksArrows() && skip > 1) {
            skip -= linkCount - linkCount / 2;
            if (--skip < 1) {
                skip = 1;
            }
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, skip, Icons.ELLIPSIS_H, null);
        }
        for (Integer prev : prevs) {
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, prev, null, null);
        }
        this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, sheet.getCurrentPage() + 1, null, BootstrapClass.ACTIVE);
        for (Integer next : nexts) {
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, next, null, null);
        }
        int n2 = skip = nexts.size() > 0 ? (Integer)nexts.get(nexts.size() - 1) : pages;
        if (!sheet.isShowDirectLinksArrows() && skip < pages) {
            skip += linkCount / 2;
            if (++skip > pages) {
                skip = pages;
            }
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, skip, Icons.ELLIPSIS_H, null);
        }
    }

    private UILink ensurePagingCommand(Application application, UISheet sheet, String facet, SheetAction action, boolean disabled) {
        Map facets = sheet.getFacets();
        UILink command = (UILink)facets.get(facet);
        if (command == null) {
            command = (UILink)application.createComponent("org.apache.myfaces.tobago.Link");
            command.setRendererType("SheetPageCommand");
            command.setRendered(true);
            ComponentUtils.setAttribute((UIComponent)command, Attributes.sheetAction, (Object)action);
            command.setDisabled(disabled);
            facets.put(facet, command);
            AjaxBehavior behavior = this.createReloadBehavior(sheet);
            command.addClientBehavior("click", (ClientBehavior)behavior);
        }
        return command;
    }

    private AjaxBehavior createReloadBehavior(UISheet sheet) {
        ArrayList<String> executeIds;
        AjaxBehavior reloadBehavior = this.findReloadBehavior(sheet);
        ArrayList<String> renderIds = new ArrayList<String>();
        if (!renderIds.contains(sheet.getId())) {
            renderIds.add(sheet.getId());
        }
        if (reloadBehavior != null) {
            renderIds.addAll(reloadBehavior.getRender());
        }
        if (!(executeIds = new ArrayList<String>()).contains(sheet.getId())) {
            executeIds.add(sheet.getId());
        }
        if (reloadBehavior != null) {
            executeIds.addAll(reloadBehavior.getExecute());
        }
        AjaxBehavior behavior = new AjaxBehavior();
        behavior.setExecute(executeIds);
        behavior.setRender(renderIds);
        return behavior;
    }

    private AjaxBehavior findReloadBehavior(ClientBehaviorHolder holder) {
        List reload = (List)holder.getClientBehaviors().get("reload");
        if (reload != null && !reload.isEmpty() && reload.get(0) instanceof AjaxBehavior) {
            return (AjaxBehavior)reload.get(0);
        }
        return null;
    }
}

