/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LinkRenderer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetPageCommandRenderer
extends LinkRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SheetPageCommandRenderer.class);

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sourceId = '" + sourceId + "'");
            LOG.debug("clientId = '" + clientId + "'");
        }
        if (clientId.equals(sourceId)) {
            SheetAction action = (SheetAction)((Object)ComponentUtils.getAttribute(component, Attributes.sheetAction));
            ActionEvent event = null;
            switch (action) {
                case first: 
                case prev: 
                case next: 
                case last: {
                    event = new PageActionEvent(component.getParent(), action);
                    break;
                }
                case toPage: 
                case toRow: {
                    event = new PageActionEvent(component.getParent(), action);
                    Integer target = (Integer)ComponentUtils.getAttribute(component, Attributes.pagingTarget);
                    if (target == null) {
                        Map map = facesContext.getExternalContext().getRequestParameterMap();
                        Object value = map.get(clientId);
                        try {
                            target = Integer.parseInt((String)value);
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Can't parse integer value for action " + action.name() + ": " + value);
                            break;
                        }
                    }
                    ((PageActionEvent)event).setValue(target);
                    break;
                }
                case sort: {
                    UIColumn column = (UIColumn)component.getParent();
                    UIData data = (UIData)column.getParent();
                    event = new SortActionEvent(data, column);
                    break;
                }
                default: {
                    LOG.error("Unknown action '{}' found!", (Object)action);
                }
            }
            component.queueEvent((FacesEvent)event);
        }
    }
}

