/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.UILabel;
import org.apache.myfaces.tobago.component.UISeparator;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SeparatorRenderer
extends RendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISeparator separator = (UISeparator)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = separator.getClientId(facesContext);
        String label = this.getLabel(separator);
        if (label != null) {
            writer.startElement(HtmlElements.P);
            writer.writeIdAttribute(clientId);
            writer.writeClassAttribute(Classes.create((UIComponent)separator), separator.getCustomClass());
            writer.writeText(label);
            writer.endElement(HtmlElements.P);
        } else {
            writer.startElement(HtmlElements.HR);
            writer.writeIdAttribute(clientId);
            writer.writeClassAttribute(Classes.create((UIComponent)separator), separator.getCustomClass());
            writer.endElement(HtmlElements.HR);
        }
    }

    private String getLabel(UISeparator separator) {
        String label = separator.getLabel();
        UIComponent facet = ComponentUtils.getFacet((UIComponent)separator, Facets.label);
        if (label == null && facet != null) {
            label = String.valueOf(((UILabel)facet).getValue());
        }
        return label;
    }
}

