/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UISelectOneListbox;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectOneRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneListboxRenderer
extends SelectOneRendererBase {
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectOneListbox select = (UISelectOneListbox)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = select.getClientId(facesContext);
        String fieldId = select.getFieldId(facesContext);
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, (UIComponent)select);
        boolean disabled = !items.iterator().hasNext() || select.isDisabled() || select.isReadonly();
        Integer size = select.getSize();
        size = Math.max(size != null ? size.intValue() : items.size(), 2);
        writer.startElement(HtmlElements.SELECT);
        writer.writeIdAttribute(fieldId);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, select.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, select.isRequired());
        HtmlRendererUtils.renderFocus(clientId, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeStyleAttribute(select.getStyle());
        writer.writeClassAttribute(Classes.create((UIComponent)select), BootstrapClass.FORM_CONTROL, select.getCustomClass());
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
        HtmlRendererUtils.renderSelectItems((UIInput)select, items, select.getValue(), (String)select.getSubmittedValue(), writer, facesContext);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SELECT);
    }
}

