/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UISelectManyShuttle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectManyRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyShuttleRenderer
extends SelectManyRendererBase {
    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        Integer size;
        UISelectManyShuttle select = (UISelectManyShuttle)component;
        String clientId = select.getClientId(facesContext);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        if (select.isLabelLayoutSkip()) {
            writer.writeIdAttribute(clientId);
        }
        writer.writeClassAttribute(Classes.create((UIComponent)select), select.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        boolean hasLabel = select.hasLabel();
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, (UIComponent)select);
        boolean disabled = !items.iterator().hasNext() || select.isDisabled();
        boolean readonly = select.isReadonly();
        String unselectedLabel = select.getUnselectedLabel();
        if (unselectedLabel != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(Classes.create((UIComponent)select, "unselectedLabel"));
            writer.write(unselectedLabel);
            writer.endElement(HtmlElements.DIV);
        }
        size = Math.max((size = select.getSize()) != null ? size.intValue() : items.size(), 2);
        writer.startElement(HtmlElements.SELECT);
        String unselectedClientId = clientId + "::" + "unselected";
        writer.writeIdAttribute(unselectedClientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeClassAttribute(Classes.create((UIComponent)select, "unselected"), BootstrapClass.FORM_CONTROL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        Object[] values = select.getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)select);
        HtmlRendererUtils.renderSelectItems((UIInput)select, items, values, submittedValues, false, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(Classes.create((UIComponent)select, "toolBar"));
        writer.startElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_DOUBLE_RIGHT, "addAll");
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_RIGHT, "add");
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_LEFT, "remove");
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_DOUBLE_LEFT, "removeAll");
        writer.startElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        String selectedLabel = select.getSelectedLabel();
        if (selectedLabel != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(Classes.create((UIComponent)select, "selectedLabel"));
            writer.write(selectedLabel);
            writer.endElement(HtmlElements.DIV);
        }
        writer.startElement(HtmlElements.SELECT);
        String selectedClientId = clientId + "::" + "selected";
        writer.writeIdAttribute(selectedClientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeClassAttribute(Classes.create((UIComponent)select, "selected"), BootstrapClass.FORM_CONTROL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        HtmlRendererUtils.renderSelectItems((UIInput)select, items, values, submittedValues, true, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
        writer.startElement(HtmlElements.SELECT);
        writer.writeClassAttribute(Classes.create(component, "hidden"));
        String hiddenClientId = clientId + "::" + "hidden";
        writer.writeIdAttribute(hiddenClientId);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, select.isRequired());
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
        HtmlRendererUtils.renderSelectItems((UIInput)select, items, values, submittedValues, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
    }

    @Override
    public void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    private void createButton(FacesContext context, UIComponent component, TobagoResponseWriter writer, boolean disabled, Icons icon, String sub) throws IOException {
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(Classes.create(component, sub), BootstrapClass.BTN, BootstrapClass.BTN_SECONDARY);
        writer.writeIdAttribute(component.getClientId(context) + "::" + sub);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeIcon(icon, new CssItem[0]);
        writer.endElement(HtmlElements.BUTTON);
    }
}

