/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectBooleanCheckbox;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBooleanCheckboxRenderer
extends LabelLayoutRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectBooleanCheckboxRenderer.class);

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        UIInput input = (UIInput)component;
        if (ComponentUtils.isOutputOnly((UIComponent)input)) {
            return;
        }
        String newValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(input.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug("new value = '" + newValue + "'");
        }
        input.setSubmittedValue((Object)("true".equals(newValue) ? "true" : "false"));
        RenderUtils.decodeClientBehaviors(facesContext, (UIComponent)input);
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISelectBooleanCheckbox select = (AbstractUISelectBooleanCheckbox)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = select.getClientId(facesContext);
        String fieldId = select.getFieldId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)select);
        boolean checked = "true".equals(currentValue);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey(select, true);
        String itemLabel = select.getItemLabel();
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId);
        writer.writeStyleAttribute(select.getStyle());
        writer.writeClassAttribute(Classes.create((UIComponent)select), BootstrapClass.FORM_CHECK, disabled ? BootstrapClass.DISABLED : null, select.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.startElement(HtmlElements.LABEL);
        writer.writeClassAttribute(BootstrapClass.FORM_CHECK_LABEL);
        if (!disabled && label.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), clientId);
        }
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
        writer.writeAttribute(HtmlAttributes.VALUE, "true", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, select.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, select.isRequired());
        HtmlRendererUtils.renderFocus(clientId, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
        writer.endElement(HtmlElements.INPUT);
        if (itemLabel != null) {
            writer.writeText(itemLabel);
        }
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.LABEL);
        writer.endElement(HtmlElements.DIV);
    }
}

