/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.component.UISegmentLayout;
import org.apache.myfaces.tobago.internal.component.AbstractUISegmentLayout;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentLayoutRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentLayoutRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISegmentLayout layout = (AbstractUISegmentLayout)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(Classes.create((UIComponent)layout), BootstrapClass.ROW);
        writer.writeIdAttribute(layout.getClientId(facesContext));
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UISegmentLayout segmentLayout = (UISegmentLayout)component;
        if (!segmentLayout.isRendered()) {
            return;
        }
        List children = segmentLayout.getChildren();
        BootstrapClass.Generator generator = new BootstrapClass.Generator(segmentLayout.getExtraSmall(), segmentLayout.getSmall(), segmentLayout.getMedium(), segmentLayout.getLarge());
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            this.encodeChild(facesContext, writer, generator, child);
        }
    }

    private void encodeChild(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        if (child instanceof SupportsLabelLayout && LabelLayout.isSegment(((SupportsLabelLayout)child).getLabelLayout())) {
            LabelLayout.setSegment(facesContext, LabelLayout.segmentLeft);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            LabelLayout.setSegment(facesContext, LabelLayout.segmentRight);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            LabelLayout.removeSegment(facesContext);
        } else {
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
        }
    }

    private void encodeDiv(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(null, null, generator.generate());
        RenderUtils.encode(facesContext, child);
        writer.endElement(HtmlElements.DIV);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }
}

