/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecodingInputRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public abstract class LabelLayoutRendererBase
extends DecodingInputRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        this.encodeBeginSurrounding(facesContext, component);
        switch (this.getType(component)) {
            case segmentLeft: {
                if (LabelLayout.getSegment(facesContext) != LabelLayout.segmentRight) break;
                this.encodeBeginField(facesContext, component);
                break;
            }
            case segmentRight: {
                if (LabelLayout.getSegment(facesContext) != LabelLayout.segmentLeft) break;
                this.encodeBeginField(facesContext, component);
                break;
            }
            default: {
                this.encodeBeginField(facesContext, component);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        switch (this.getType(component)) {
            case segmentLeft: {
                if (LabelLayout.getSegment(facesContext) != LabelLayout.segmentRight) break;
                this.encodeEndField(facesContext, component);
                break;
            }
            case segmentRight: {
                if (LabelLayout.getSegment(facesContext) != LabelLayout.segmentLeft) break;
                this.encodeEndField(facesContext, component);
                break;
            }
            default: {
                this.encodeEndField(facesContext, component);
            }
        }
        this.encodeEndSurrounding(facesContext, component);
    }

    protected abstract void encodeBeginField(FacesContext var1, UIComponent var2) throws IOException;

    protected abstract void encodeEndField(FacesContext var1, UIComponent var2) throws IOException;

    protected void encodeBeginSurrounding(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoClass divClass;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        LabelLayout labelLayout = this.getType(component);
        switch (labelLayout) {
            case skip: {
                return;
            }
            case flexLeft: 
            case flexRight: {
                divClass = TobagoClass.FLEX_LAYOUT;
                break;
            }
            default: {
                divClass = null;
            }
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(divClass, BootstrapClass.FORM_GROUP, BootstrapClass.maximumSeverity(component), ComponentUtils.getBooleanAttribute(component, Attributes.required) ? TobagoClass.REQUIRED : null);
        switch (labelLayout) {
            case flexLeft: {
                writer.writeAttribute(DataAttributes.LAYOUT, "{\"columns\":[\"auto\",1]}", true);
                break;
            }
            case flexRight: {
                writer.writeAttribute(DataAttributes.LAYOUT, "{\"columns\":[1,\"auto\"]}", true);
                break;
            }
        }
        switch (labelLayout) {
            case flexRight: 
            case none: 
            case flowRight: {
                break;
            }
            case segmentLeft: {
                if (LabelLayout.getSegment(facesContext) != LabelLayout.segmentLeft) break;
                this.encodeLabel(component, writer, labelLayout);
                break;
            }
            case segmentRight: {
                if (LabelLayout.getSegment(facesContext) != LabelLayout.segmentRight) break;
                this.encodeLabel(component, writer, labelLayout);
                break;
            }
            default: {
                this.encodeLabel(component, writer, labelLayout);
            }
        }
    }

    protected void encodeEndSurrounding(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        LabelLayout labelLayout = this.getType(component);
        switch (labelLayout) {
            case skip: {
                return;
            }
            case flexRight: 
            case flowRight: {
                this.encodeLabel(component, writer, labelLayout);
                break;
            }
        }
        writer.endElement(HtmlElements.DIV);
    }

    protected void encodeLabel(UIComponent component, TobagoResponseWriter writer, LabelLayout labelLayout) throws IOException {
        String label = ComponentUtils.getStringAttribute(component, Attributes.label);
        if (StringUtils.isNotBlank(label)) {
            writer.startElement(HtmlElements.LABEL);
            writer.writeAttribute(HtmlAttributes.FOR, component.getClientId(), false);
            writer.writeClassAttribute(TobagoClass.LABEL, BootstrapClass.COL_FORM_LABEL);
            if (component instanceof SupportsAccessKey) {
                LabelWithAccessKey labelWithAccessKey = new LabelWithAccessKey((SupportsAccessKey)component);
                HtmlRendererUtils.writeLabelWithAccessKey(writer, labelWithAccessKey);
            } else {
                writer.writeText(label);
            }
            writer.endElement(HtmlElements.LABEL);
        }
    }

    private LabelLayout getType(UIComponent component) {
        return component instanceof SupportsLabelLayout ? ((SupportsLabelLayout)component).getLabelLayout() : LabelLayout.skip;
    }
}

