/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUIButton;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InRenderer
extends LabelLayoutRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(InRenderer.class);

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIInput input = (AbstractUIInput)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)input);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
        boolean password = ComponentUtils.getBooleanAttribute((UIComponent)input, Attributes.password);
        if (LOG.isDebugEnabled()) {
            LOG.debug("currentValue = '{}'", (Object)StringUtils.toConfidentialString(currentValue, password));
        }
        HtmlInputTypes type = password ? HtmlInputTypes.PASSWORD : HtmlInputTypes.TEXT;
        String clientId = input.getClientId(facesContext);
        String fieldId = input.getFieldId(facesContext);
        boolean readonly = input.isReadonly();
        boolean disabled = input.isDisabled();
        boolean required = ComponentUtils.getBooleanAttribute((UIComponent)input, Attributes.required);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent after = ComponentUtils.getFacet((UIComponent)input, Facets.after);
        UIComponent before = ComponentUtils.getFacet((UIComponent)input, Facets.before);
        if (after != null || before != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.INPUT__GROUP__OUTER);
            if (input.isLabelLayoutSkip()) {
                writer.writeIdAttribute(clientId);
            }
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.INPUT_GROUP);
        }
        this.encodeGroupAddon(facesContext, writer, before);
        writer.startElement(HtmlElements.INPUT);
        if (input.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(input.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, input.getAccessKey(), clientId);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, type);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)input);
        if (currentValue != null && !password) {
            writer.writeAttribute(HtmlAttributes.VALUE, currentValue, true);
        }
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        int maxLength = 0;
        String pattern = null;
        for (Validator validator : input.getValidators()) {
            if (!(validator instanceof LengthValidator)) continue;
            LengthValidator lengthValidator = (LengthValidator)validator;
            maxLength = lengthValidator.getMaximum();
        }
        if (maxLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
        }
        if (pattern != null) {
            writer.writeAttribute(HtmlAttributes.PATTERN, pattern, false);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, input.getTabIndex());
        writer.writeStyleAttribute(input.getStyle());
        String placeholder = input.getPlaceholder();
        if (!disabled && !readonly && StringUtils.isNotBlank(placeholder)) {
            writer.writeAttribute(HtmlAttributes.PLACEHOLDER, placeholder, true);
        }
        writer.writeClassAttribute(Classes.create((UIComponent)input), BootstrapClass.FORM_CONTROL, input.getCustomClass());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        HtmlRendererUtils.renderFocus(clientId, input.isFocus(), ComponentUtils.isError(input), facesContext, writer);
        this.writeAdditionalAttributes(facesContext, writer, input);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, input)));
        writer.endElement(HtmlElements.INPUT);
        this.encodeGroupAddon(facesContext, writer, after);
        if (after != null || before != null) {
            writer.endElement(HtmlElements.DIV);
            writer.endElement(HtmlElements.DIV);
        }
    }

    private void encodeGroupAddon(FacesContext facesContext, TobagoResponseWriter writer, UIComponent addon) throws IOException {
        if (addon != null) {
            List<UIComponent> children = addon instanceof UIPanel ? addon.getChildren() : Collections.singletonList(addon);
            for (UIComponent child : children) {
                writer.startElement(HtmlElements.SPAN);
                BootstrapClass css = child instanceof AbstractUIButton ? BootstrapClass.INPUT_GROUP_BTN : BootstrapClass.INPUT_GROUP_ADDON;
                writer.writeClassAttribute(css);
                RenderUtils.encode(facesContext, child);
                writer.endElement(HtmlElements.SPAN);
            }
        }
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
    }

    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIInput input) throws IOException {
    }
}

