/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.layout.LayoutToken;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridLayoutRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(GridLayoutRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIGridLayout gridLayout = (AbstractUIGridLayout)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.TABLE);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PRESENTATION.toString(), false);
        writer.writeClassAttribute(Classes.create((UIComponent)gridLayout));
        StringBuilder builder = new StringBuilder();
        builder.append("{\"columns\":");
        JsonUtils.encode(gridLayout.getGrid().getColumns(), builder);
        builder.append(",");
        builder.append("\"rows\":");
        JsonUtils.encode(gridLayout.getGrid().getRows(), builder);
        builder.append("}");
        writer.writeAttribute(DataAttributes.LAYOUT, builder.toString(), true);
        writer.startElement(HtmlElements.COLGROUP);
        LayoutTokens columns = gridLayout.getGrid().getColumns();
        for (LayoutToken column : columns.getTokens()) {
            writer.startElement(HtmlElements.COL);
            writer.endElement(HtmlElements.COL);
        }
        writer.endElement(HtmlElements.COLGROUP);
        writer.startElement(HtmlElements.TBODY);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIGridLayout gridLayout = (AbstractUIGridLayout)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Grid grid = gridLayout.getGrid();
        int columns = grid.getColumnCount();
        int rows = grid.getRowCount();
        for (int i = 0; i < rows; ++i) {
            writer.startElement(HtmlElements.TR);
            for (int j = 0; j < columns; ++j) {
                Measure height;
                int rowSpan;
                Cell cell = grid.getCell(j, i);
                if (!(cell instanceof OriginCell)) continue;
                writer.startElement(HtmlElements.TD);
                int columnSpan = cell.getColumnSpan();
                if (columnSpan > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, columnSpan);
                }
                if ((rowSpan = cell.getRowSpan()) > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWSPAN, rowSpan);
                }
                UIComponent element = cell.getComponent();
                StringBuilder builder = new StringBuilder();
                builder.append("{");
                Measure width = Measure.valueOf(ComponentUtils.getAttribute(element, Attributes.width));
                if (width != null) {
                    builder.append("\"width\":");
                    builder.append(width.serialize());
                    builder.append(",");
                }
                if ((height = Measure.valueOf(ComponentUtils.getAttribute(element, Attributes.height))) != null) {
                    builder.append("\"height\":");
                    builder.append(height.serialize());
                    builder.append(",");
                }
                if (builder.length() > 1) {
                    builder.deleteCharAt(builder.length() - 1);
                }
                builder.append("}");
                if (builder.length() > 2) {
                    ComponentUtils.putDataAttribute(element, "tobago-layout", builder.toString());
                }
                RenderUtils.encode(facesContext, element);
                writer.endElement(HtmlElements.TD);
            }
            writer.endElement(HtmlElements.TR);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TBODY);
        writer.endElement(HtmlElements.TABLE);
    }
}

