/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.validator.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.internal.component.AbstractUIFile;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.HttpPartWrapper;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.PartUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.validator.FileItemValidator;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class FileRenderer
extends LabelLayoutRendererBase
implements ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(FileRenderer.class);

    public void processEvent(ComponentSystemEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FacesContextUtils.setEnctype(facesContext, "multipart/form-data");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        block9: {
            if (ComponentUtils.isOutputOnly(component)) {
                return;
            }
            AbstractUIFile file = (AbstractUIFile)component;
            Object request = facesContext.getExternalContext().getRequest();
            if (request instanceof HttpServletRequest) {
                try {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                    if (file.isMultiple()) {
                        ArrayList<HttpPartWrapper> parts = new ArrayList<HttpPartWrapper>();
                        for (Part part : httpServletRequest.getParts()) {
                            if (file.getClientId(facesContext).equals(part.getName())) {
                                LOG.debug("Uploaded file '{}', size={}, type='{}'", new Object[]{PartUtils.getSubmittedFileName(part), part.getSize(), part.getContentType()});
                                parts.add(new HttpPartWrapper(part));
                            }
                            file.setSubmittedValue(parts.toArray(new Part[parts.size()]));
                        }
                        break block9;
                    }
                    Part part = httpServletRequest.getPart(file.getClientId(facesContext));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Uploaded file '{}', size={}, type='{}'", new Object[]{PartUtils.getSubmittedFileName(part), part.getSize(), part.getContentType()});
                    }
                    file.setSubmittedValue(new HttpPartWrapper(part));
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    file.setValid(false);
                }
            } else {
                LOG.warn("Unsupported request type: " + request.getClass().getName());
            }
        }
        RenderUtils.decodeClientBehaviors(facesContext, component);
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIFile file = (AbstractUIFile)component;
        String clientId = file.getClientId(facesContext);
        String fieldId = file.getFieldId(facesContext);
        String accept = this.createAcceptFromValidators(file);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(Classes.create((UIComponent)file), file.getCustomClass());
        if (file.isLabelLayoutSkip()) {
            writer.writeIdAttribute(clientId);
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)file);
        writer.writeStyleAttribute(file.getStyle());
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.INPUT_GROUP);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
        writer.writeAttribute(HtmlAttributes.ACCEPT, accept, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, -1);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, file.isDisabled() || file.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, file.isReadonly());
        writer.writeClassAttribute(Classes.create((UIComponent)file, "pretty"), BootstrapClass.FORM_CONTROL);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, file.isMultiple());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.FILE);
        writer.writeAttribute(HtmlAttributes.ACCEPT, accept, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, -1);
        writer.writeIdAttribute(fieldId);
        writer.writeClassAttribute(Classes.create((UIComponent)file, "real"));
        writer.writeNameAttribute(clientId);
        String multiFormat = TobagoResourceBundle.getString(facesContext, "tobago.file.multiFormat");
        writer.writeAttribute(DataAttributes.dynamic("tobago-file-multi-format"), multiFormat, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, file.isDisabled() || file.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, file.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, file.isRequired());
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)file);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, file)));
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(BootstrapClass.INPUT_GROUP_BTN);
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, file.getTabIndex());
        writer.writeClassAttribute(BootstrapClass.BTN, BootstrapClass.BTN_SECONDARY);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, file.isDisabled() || file.isReadonly());
        writer.writeIcon(Icons.FOLDER_OPEN, new CssItem[0]);
        writer.endElement(HtmlElements.BUTTON);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.DIV);
    }

    private String createAcceptFromValidators(AbstractUIFile file) {
        StringBuilder builder = new StringBuilder();
        for (Validator validator : file.getValidators()) {
            if (!(validator instanceof FileItemValidator)) continue;
            FileItemValidator fileItemValidator = (FileItemValidator)validator;
            for (String contentType : fileItemValidator.getContentType()) {
                builder.append(",");
                builder.append(contentType);
            }
        }
        if (builder.length() > 0) {
            return builder.substring(1);
        }
        return null;
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }
}

