/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.UITextarea;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecodingInputRendererBase
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(DecodingInputRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            return;
        }
        if (ComponentUtils.isOutputOnly(component)) {
            return;
        }
        String clientId = component.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            String newValue = (String)requestParameterMap.get(clientId);
            if (LOG.isDebugEnabled()) {
                boolean password = ComponentUtils.getBooleanAttribute(component, Attributes.password);
                LOG.debug("clientId='{}'", (Object)clientId);
                LOG.debug("requestParameterMap.get(clientId)='{}'", (Object)StringUtils.toConfidentialString(newValue, password));
            }
            if (component instanceof UITextarea) {
                UITextarea textarea = (UITextarea)component;
                if (ComponentUtils.getDataAttribute(component, "html-editor") != null && SanitizeMode.auto == textarea.getSanitize()) {
                    Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                    newValue = sanitizer.sanitize(newValue);
                }
            }
            ((EditableValueHolder)component).setSubmittedValue((Object)newValue);
        }
        RenderUtils.decodeClientBehaviors(facesContext, component);
    }
}

