/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUIBox;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer
extends PanelRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIBox box = (AbstractUIBox)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent label = ComponentUtils.getFacet((UIComponent)box, Facets.label);
        String labelString = box.getLabel();
        UIComponent bar = ComponentUtils.getFacet((UIComponent)box, Facets.bar);
        writer.startElement(HtmlElements.DIV);
        boolean collapsed = box.isCollapsed();
        writer.writeClassAttribute(Classes.create((UIComponent)box), collapsed ? TobagoClass.COLLAPSED : null, BootstrapClass.CARD, box.getCustomClass());
        String clientId = box.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)box);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)box);
        writer.writeStyleAttribute(box.getStyle());
        if (box.getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        if (label != null || labelString != null || bar != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.CARD_HEADER);
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.BOX__HEADER);
            writer.startElement(HtmlElements.H3);
            if (labelString != null) {
                writer.writeText(labelString);
            }
            if (label != null) {
                RenderUtils.encode(facesContext, label);
            }
            writer.endElement(HtmlElements.H3);
            if (bar != null) {
                RenderUtils.encode(facesContext, bar);
            }
            writer.endElement(HtmlElements.DIV);
            writer.endElement(HtmlElements.DIV);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CARD_BLOCK);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
    }
}

