/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.UIBar;
import org.apache.myfaces.tobago.internal.component.AbstractUIFormBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JQueryUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BarRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIBar bar = (UIBar)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = bar.getClientId(facesContext);
        String navbarId = clientId + "::navbar";
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.NAVIGATION.toString(), false);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)bar);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CONTAINER_FLUID);
        this.encodeOpener(facesContext, bar, writer, navbarId);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(navbarId);
        writer.writeClassAttribute(BootstrapClass.COLLAPSE, BootstrapClass.NAVBAR_TOGGLEABLE_XS);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        ArrayList<UIComponent> itemsToEncode = new ArrayList<UIComponent>();
        this.collectItemsToEncode(component, itemsToEncode);
        for (UIComponent child : itemsToEncode) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.FORM_INLINE);
            child.encodeAll(facesContext);
            writer.endElement(HtmlElements.DIV);
        }
    }

    private void collectItemsToEncode(UIComponent component, List<UIComponent> result) {
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof AbstractUIFormBase) {
                this.collectItemsToEncode(child, result);
                continue;
            }
            result.add(child);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
    }

    private void encodeOpener(FacesContext facesContext, UIBar bar, TobagoResponseWriter writer, String navbarId) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.NAVBAR_TOGGLER, BootstrapClass.HIDDEN_SM_UP);
        writer.writeAttribute(DataAttributes.TOGGLE, "collapse", false);
        writer.writeAttribute(DataAttributes.TARGET, JQueryUtils.escapeIdForHtml(navbarId), true);
        writer.writeAttribute(Arias.EXPANDED, Boolean.FALSE.toString(), false);
        writer.writeAttribute(Arias.CONTROLS, navbarId, false);
        writer.writeIcon(Icons.BARS, new CssItem[0]);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(BootstrapClass.SR_ONLY);
        writer.writeText("Toggle navigation");
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.BUTTON);
        UIComponent brand = ComponentUtils.getFacet((UIComponent)bar, Facets.brand);
        if (brand != null) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeClassAttribute(BootstrapClass.NAVBAR_BRAND);
            RenderUtils.encode(facesContext, brand);
            writer.endElement(HtmlElements.SPAN);
        }
        writer.endElement(HtmlElements.DIV);
    }
}

