/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentSecurityPolicy {
    private Mode mode;
    private List<String> directiveList;
    private boolean unmodifiable = false;

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new RuntimeException("The configuration must not be changed after initialization!");
        }
    }

    public void lock() {
        this.unmodifiable = true;
        this.directiveList = Collections.unmodifiableList(this.directiveList);
    }

    public ContentSecurityPolicy(String mode) {
        this.mode = Mode.parse(mode);
        this.directiveList = new ArrayList<String>();
    }

    public void merge(ContentSecurityPolicy other) {
        this.checkLocked();
        this.directiveList.addAll(other.directiveList);
        this.mode = other.mode;
    }

    public List<String> getDirectiveList() {
        return this.directiveList;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String toString() {
        return "ContentSecurityPolicy{mode=" + (Object)((Object)this.mode) + ", directiveList=" + this.directiveList + '}';
    }

    public static enum Mode {
        ON("on"),
        OFF("off"),
        REPORT_ONLY("report-only");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Mode parse(String string) {
            if (Mode.ON.value.equals(string)) {
                return ON;
            }
            if (Mode.OFF.value.equals(string)) {
                return OFF;
            }
            if (Mode.REPORT_ONLY.value.equals(string)) {
                return REPORT_ONLY;
            }
            throw new IllegalArgumentException("Found: " + string);
        }
    }
}

