/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PreRenderComponentEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public abstract class AbstractUIGridLayout
extends AbstractUILayoutBase
implements Visual,
ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIGridLayout.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.GridLayout";
    private Grid grid;

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (!this.isRendered()) {
            return;
        }
        if (event instanceof PreRenderComponentEvent) {
            this.grid = new Grid(LayoutTokens.parse(this.getColumns()), LayoutTokens.parse(this.getRows()));
            List<UIComponent> components = LayoutUtils.findLayoutChildren((UIComponent)this);
            for (UIComponent component : components) {
                int columnSpan = ComponentUtils.getIntAttribute(component, Attributes.column, 1);
                int rowSpan = ComponentUtils.getIntAttribute(component, Attributes.row, 1);
                this.grid.add(new OriginCell(component), columnSpan, rowSpan);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("\n" + this.grid);
            }
        }
    }

    public abstract String getRows();

    public abstract void setRows(String var1);

    public abstract String getColumns();

    public abstract void setColumns(String var1);

    public abstract boolean isRigid();

    public Grid getGrid() {
        return this.grid;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("#");
        builder.append(this.getClientId(FacesContext.getCurrentInstance()));
        builder.append("\n");
        if (this.grid != null) {
            builder.append(StringUtils.repeat("  ", 4));
            builder.append("horiz.: ");
            LayoutTokens rows = this.grid.getRows();
            for (int i = 0; i < rows.getSize(); ++i) {
                if (i != 0) {
                    builder.append(StringUtils.repeat("  ", 8));
                }
                builder.append(rows.get(i));
                builder.append("\n");
            }
            builder.append(StringUtils.repeat("  ", 4));
            builder.append("verti.: ");
            LayoutTokens columns = this.grid.getColumns();
            for (int i = 0; i < columns.getSize(); ++i) {
                if (i != 0) {
                    builder.append(StringUtils.repeat("  ", 8));
                }
                builder.append(columns.get(i));
                builder.append("\n");
            }
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }
}

