/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.swing.tree.TreeNode;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.internal.component.AbstractUIRow;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreeDataModel;
import org.apache.myfaces.tobago.model.TreeNodeDataModel;
import org.apache.myfaces.tobago.model.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUIData
extends UIData
implements Visual {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIData.class);
    @Deprecated
    public static final String SUFFIX_MARKED = "marked";
    public static final String SUFFIX_SELECTED = "selected";
    public static final String SUFFIX_EXPANDED = "expanded";
    private boolean initialized;
    private TreeDataModel dataModel;

    public boolean isTreeModel() {
        this.init();
        return this.dataModel != null;
    }

    public TreeDataModel getTreeDataModel() {
        if (this.isTreeModel()) {
            return this.dataModel;
        }
        LOG.warn("Not a tree model");
        return null;
    }

    protected DataModel getDataModel() {
        this.init();
        if (this.dataModel != null) {
            return this.dataModel;
        }
        return super.getDataModel();
    }

    private void init() {
        if (!this.initialized) {
            Object value = this.getValue();
            boolean showRoot = this.isShowRoot();
            this.createTreeDataModel(value, showRoot);
            this.initialized = true;
        }
    }

    public Selectable getSelectableAsEnum() {
        return this.getSelectable();
    }

    public abstract Selectable getSelectable();

    protected void createTreeDataModel(Object value, boolean showRoot) {
        if (value instanceof TreeNode) {
            this.dataModel = new TreeNodeDataModel((TreeNode)value, showRoot, this.getExpandedState());
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.initialized = false;
        this.init();
        if (this.dataModel != null) {
            this.dataModel.reset();
        }
        super.encodeBegin(context);
    }

    public abstract ExpandedState getExpandedState();

    public abstract SelectedState getSelectedState();

    @Deprecated
    public boolean hasRows() {
        return this.getRows() != 0;
    }

    public boolean isRowVisible() {
        this.init();
        if (this.dataModel != null) {
            return this.dataModel.isRowVisible();
        }
        return super.getDataModel().isRowAvailable();
    }

    public String getRowClientId() {
        this.init();
        return this.dataModel != null ? this.dataModel.getRowClientId() : null;
    }

    public String getRowParentClientId() {
        this.init();
        return this.dataModel != null ? this.dataModel.getRowParentClientId() : null;
    }

    public abstract boolean isShowRoot();

    public boolean isShowRootJunction() {
        return false;
    }

    public boolean isRowsUnlimited() {
        return this.getRows() == 0;
    }

    public boolean isRendersRowContainer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext facesContext, String clientId, ContextCallback callback) throws FacesException {
        int oldRowIndex = this.getRowIndex();
        try {
            String sheetId = this.getClientId(facesContext);
            if (clientId.startsWith(sheetId)) {
                String idRemainder = clientId.substring(sheetId.length());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("idRemainder = '" + idRemainder + "'");
                }
                if (idRemainder.matches("^:\\d+:.*")) {
                    idRemainder = idRemainder.substring(1);
                    int idx = idRemainder.indexOf(":");
                    try {
                        int rowIndex = Integer.parseInt(idRemainder.substring(0, idx));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("set rowIndex = '" + rowIndex + "'");
                        }
                        this.setRowIndex(rowIndex);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("idRemainder = '" + idRemainder + "'", (Throwable)e);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("no match for '^:\\d+:.*'");
                }
            }
            boolean bl = super.invokeOnComponent(facesContext, clientId, callback);
            return bl;
        }
        finally {
            this.setRowIndex(oldRowIndex);
        }
    }

    public TreePath getPath() {
        if (this.isTreeModel()) {
            return ((TreeDataModel)this.getDataModel()).getPath();
        }
        LOG.warn("Not a tree model");
        return null;
    }

    public boolean isFolder() {
        if (this.isTreeModel()) {
            return ((TreeDataModel)this.getDataModel()).isFolder();
        }
        LOG.warn("Not a tree model");
        return false;
    }

    public List<Integer> getRowIndicesOfChildren() {
        if (this.isTreeModel()) {
            return this.dataModel.getRowIndicesOfChildren();
        }
        LOG.warn("Not a tree model");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (super.visitTree(context, callback)) {
            return true;
        }
        int oldRowIndex = this.getRowIndex();
        this.setRowIndex(-1);
        this.pushComponentToEL(context.getFacesContext(), (UIComponent)this);
        try {
            int rowsToProcess = this.getRows();
            if (rowsToProcess == 0) {
                rowsToProcess = this.getRowCount();
            }
            int rowIndex = this.getFirst();
            int rowsProcessed = 0;
            while (rowsProcessed < rowsToProcess) {
                this.setRowIndex(rowIndex);
                if (!this.isRowAvailable()) {
                    boolean bl = false;
                    return bl;
                }
                int childCount = this.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)this.getChildren().get(i);
                    if (!(child instanceof AbstractUIRow) || !child.visitTree(context, callback)) continue;
                    boolean bl = true;
                    return bl;
                }
                ++rowsProcessed;
                ++rowIndex;
            }
        }
        finally {
            this.popComponentFromEL(context.getFacesContext());
            this.setRowIndex(oldRowIndex);
        }
        return false;
    }
}

