/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUICollapsiblePanel
extends AbstractUIPanelBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUICollapsiblePanel.class);
    private transient Boolean submittedCollapsed;

    public void processDecodes(FacesContext facesContext) {
        if (this.isNormalLifecycle()) {
            super.processDecodes(facesContext);
        } else {
            this.decode(facesContext);
            UIComponent bar = this.getFacet("bar");
            if (bar != null) {
                bar.processDecodes(facesContext);
            }
        }
    }

    public void processValidators(FacesContext facesContext) {
        if (this.isNormalLifecycle()) {
            super.processValidators(facesContext);
        } else {
            UIComponent bar = this.getFacet("bar");
            if (bar != null) {
                bar.processValidators(facesContext);
            }
        }
    }

    public void processUpdates(FacesContext facesContext) {
        if (this.isNormalLifecycle()) {
            super.processUpdates(facesContext);
        } else {
            UIComponent bar = this.getFacet("bar");
            if (bar != null) {
                bar.processUpdates(facesContext);
            }
        }
    }

    public boolean isNormalLifecycle() {
        return this.getCollapsedMode() == CollapseMode.hidden || !this.isCollapsed();
    }

    public abstract boolean isCollapsed();

    public abstract void setCollapsed(boolean var1);

    public abstract CollapseMode getCollapsedMode();

    public void setSubmittedCollapsed(Boolean submittedCollapsed) {
        this.submittedCollapsed = submittedCollapsed;
    }

    public void processState() {
        if (this.submittedCollapsed != null) {
            ValueExpression valueExpression = this.getValueExpression(Attributes.collapsed.name());
            if (valueExpression != null) {
                valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)this.submittedCollapsed);
            } else {
                this.setCollapsed(this.submittedCollapsed);
            }
            this.submittedCollapsed = null;
        }
    }
}

