/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollapsibleActionListener
implements ActionListener,
StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(CollapsibleActionListener.class);
    private String forId;
    private boolean transientFlag;

    public CollapsibleActionListener() {
    }

    public CollapsibleActionListener(String forId) {
        this.forId = forId;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            String forClientId = ComponentUtils.evaluateClientId(facesContext, actionEvent.getComponent(), this.forId);
            UIComponent component = viewRoot.findComponent(forClientId);
            if (component instanceof AbstractUICollapsiblePanel) {
                ((AbstractUICollapsiblePanel)component).processState();
            } else {
                LOG.error("Wrong component class for id: '{}'. Type is {} but expected type is {}", new Object[]{forClientId, component.getClass().getName(), AbstractUICollapsiblePanel.class.getName()});
            }
        }
    }

    public Object saveState(FacesContext context) {
        return this.forId;
    }

    public void restoreState(FacesContext context, Object state) {
        this.forId = (String)state;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }
}

