// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeMenu;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import javax.el.ELException;
import javax.faces.FacesException;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/** 
 A tree which will be displayed like a flat menu.
  This menu is often used for navigation on the left side of an application.
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.TreeMenuTagDeclaration}.
 */
public class UITreeMenu
    extends AbstractUITreeMenu implements Visual {

  public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TreeMenu";

  public static final String COMPONENT_FAMILY = "javax.faces.Data";


  enum PropertyKeys {
    showRoot,
    markup,
    customClass,
    style,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  Only applicable in the case that the data model is a tree.
   This flag indicates that the root node should be displayed.
   Often in tree structures the root node is special and should not be displayed.
  <br>Default: <code>false</code>
  */
  public boolean isShowRoot() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.showRoot);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setShowRoot(boolean showRoot) {
    getStateHelper().put(PropertyKeys.showRoot, showRoot);
  }

  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    Object object = getStateHelper().eval(PropertyKeys.markup);
    if (object != null) {
      return Markup.valueOf(object);
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    getStateHelper().put(PropertyKeys.markup, markup);
  }

  /**
  Sets a CSS class in its parent, if the parent supports it.

   Which this feature it is possible to put a CSS class name into a component with the &lt;tc:style&gt; tag. Example:

   <pre>
   &lt;tc:in&gt;
     &lt;tc:style customClass="my-emphasized"/&gt;
   &lt;/tc:in&gt;
   </pre>

   One capability is, to used external CSS libs.
   <br>
   This feature should not be used imprudent.
   Because it might be unstable against changes in the renderered HTML code.

  */
  public org.apache.myfaces.tobago.renderkit.css.CustomClass getCustomClass() {
    return (org.apache.myfaces.tobago.renderkit.css.CustomClass) getStateHelper().eval(PropertyKeys.customClass);
  }

  public void setCustomClass(org.apache.myfaces.tobago.renderkit.css.CustomClass customClass) {
    getStateHelper().put(PropertyKeys.customClass, customClass);
  }

  /**
  For internal use. Used for rendering, if there is a child tag &lt;tc:style&gt;

  */
  public org.apache.myfaces.tobago.renderkit.css.Style getStyle() {
    return (org.apache.myfaces.tobago.renderkit.css.Style) getStateHelper().eval(PropertyKeys.style);
  }

  public void setStyle(org.apache.myfaces.tobago.renderkit.css.Style style) {
    getStateHelper().put(PropertyKeys.style, style);
  }


}