/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.FontAwesomeIconEncoder;
import org.apache.myfaces.tobago.renderkit.css.IconEncoder;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;

public abstract class TobagoResponseWriter
extends ResponseWriter {
    private static final CssItem[] NO_CSS_ITEMS = new CssItem[0];
    private IconEncoder iconEncoder = new FontAwesomeIconEncoder();

    @Deprecated
    public abstract void startElement(String var1, UIComponent var2) throws IOException;

    public abstract void startElement(HtmlElements var1) throws IOException;

    @Deprecated
    public abstract void endElement(String var1) throws IOException;

    public abstract void endElement(HtmlElements var1) throws IOException;

    public abstract void write(String var1) throws IOException;

    public abstract void writeComment(Object var1) throws IOException;

    public abstract ResponseWriter cloneWithWriter(Writer var1);

    @Deprecated
    public abstract void writeAttribute(String var1, Object var2, String var3) throws IOException;

    @Deprecated
    public abstract void writeURIAttribute(String var1, Object var2, String var3) throws IOException;

    @Deprecated
    public abstract void writeText(Object var1, String var2) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void writeAttribute(MarkupLanguageAttributes var1, String var2, boolean var3) throws IOException;

    public abstract void writeAttribute(MarkupLanguageAttributes var1, HtmlTypes var2) throws IOException;

    public abstract void writeURIAttribute(MarkupLanguageAttributes var1, String var2) throws IOException;

    public void writeAttribute(MarkupLanguageAttributes name, boolean on) throws IOException {
        if (on) {
            this.writeAttribute(name, name.getValue(), false);
        }
    }

    public void writeAttribute(MarkupLanguageAttributes name, Integer number) throws IOException {
        if (number != null) {
            this.writeAttribute(name, Integer.toString(number), false);
        }
    }

    public void writeIdAttribute(String id) throws IOException {
        this.writeAttribute(HtmlAttributes.ID, id, false);
    }

    public void writeNameAttribute(String name) throws IOException {
        this.writeAttribute(HtmlAttributes.NAME, name, false);
    }

    public void writeClassAttribute(CssItem first) throws IOException {
        if (first != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(first.getName());
            builder.append(' ');
            this.writeAttribute(HtmlAttributes.CLASS, builder.deleteCharAt(builder.length() - 1).toString(), false);
        }
    }

    public void writeCommandMapAttribute(String map) throws IOException {
        if (map != null) {
            this.writeAttribute(DataAttributes.COMMANDS, map, true);
        }
    }

    public void writeClassAttribute(CssItem first, CssItem second) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean render = false;
        if (first != null) {
            builder.append(first.getName());
            builder.append(' ');
            render = true;
        }
        if (second != null) {
            builder.append(second.getName());
            builder.append(' ');
            render = true;
        }
        if (render) {
            this.writeAttribute(HtmlAttributes.CLASS, builder.deleteCharAt(builder.length() - 1).toString(), false);
        }
    }

    public void writeClassAttribute(CssItem first, CssItem second, CssItem ... others) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean render = false;
        if (first != null) {
            builder.append(first.getName());
            builder.append(' ');
            render = true;
        }
        if (second != null) {
            builder.append(second.getName());
            builder.append(' ');
            render = true;
        }
        for (CssItem other : others) {
            if (other == null) continue;
            builder.append(other.getName());
            builder.append(' ');
            render = true;
        }
        if (render) {
            this.writeAttribute(HtmlAttributes.CLASS, builder.deleteCharAt(builder.length() - 1).toString(), false);
        }
    }

    public void writeStyleAttribute(Style style) throws IOException {
        String json;
        if (style != null && (json = style.encodeJson()).length() > 2) {
            this.writeAttribute(DataAttributes.STYLE, json, style.needsToBeEscaped());
        }
    }

    @Deprecated
    public void writeStyleAttribute(String style) throws IOException {
        this.writeAttribute(HtmlAttributes.STYLE, style, false);
    }

    public void writeIcon(Icons icon, CssItem ... cssItems) throws IOException {
        this.writeIcon(icon, (Style)null, cssItems);
    }

    public void writeIcon(Icons icon, Style style, CssItem ... cssItems) throws IOException {
        this.iconEncoder.encode(this, icon, style, cssItems);
    }

    @Deprecated
    public void writeJavascript(String script) throws IOException {
        this.startJavascript();
        this.write(script);
        this.endJavascript();
    }

    @Deprecated
    public void endJavascript() throws IOException {
        this.endElement(HtmlElements.SCRIPT);
    }

    @Deprecated
    public void startJavascript() throws IOException {
        this.startElement(HtmlElements.SCRIPT);
        this.writeAttribute(HtmlAttributes.TYPE, "text/javascript", false);
    }

    public void writeText(String text) throws IOException {
        this.writeText(text, null);
    }

    public String getContentTypeWithCharSet() {
        String characterEncoding;
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "text/html";
        }
        if ((characterEncoding = this.getCharacterEncoding()) == null) {
            characterEncoding = "UTF-8";
        }
        return contentType + "; charset=" + characterEncoding;
    }

    public void startCDATA() throws IOException {
        this.write("<![CDATA[");
    }

    public void endCDATA() throws IOException {
        this.write("]]>");
    }
}

