/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomClass
implements CssItem {
    private static final Logger LOG = LoggerFactory.getLogger(CustomClass.class);
    private static final Pattern CSS_CLASS_PATTERN = Pattern.compile("[\\w-]+");
    private final String[] classes;

    private CustomClass(List<String> list) {
        this.classes = list.toArray(new String[list.size()]);
    }

    public static CustomClass valueOf(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, " ");
        ArrayList<String> result = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Matcher matcher = CSS_CLASS_PATTERN.matcher(token);
            if (matcher.matches()) {
                if (!result.contains(token)) {
                    result.add(token);
                    continue;
                }
                LOG.warn("Duplicate CSS class name: '{}' which is part of '{}'", (Object)token, (Object)text);
                continue;
            }
            LOG.error("Invalid CSS class name: '{}' which is part of '{}'", (Object)token, (Object)text);
        }
        if (result.size() > 0) {
            return new CustomClass(result);
        }
        return null;
    }

    @Override
    public String getName() {
        switch (this.classes.length) {
            case 0: {
                return "";
            }
            case 1: {
                return this.classes[0];
            }
        }
        StringBuilder builder = new StringBuilder(this.classes[0]);
        for (int i = 1; i < this.classes.length; ++i) {
            builder.append(' ');
            builder.append(this.classes[i]);
        }
        return builder.toString();
    }
}

