/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PixelMeasure {
    private static final Logger LOG = LoggerFactory.getLogger(PixelMeasure.class);
    static final PixelMeasure[] PIXEL_CACHE = new PixelMeasure[4001];
    static final int PIXEL_CACHE_MAX = 4000;
    private final int pixel;

    private PixelMeasure(int pixel) {
        this.pixel = pixel;
    }

    static PixelMeasure pixelValueOf(int value) {
        if (value >= 0 && value <= 4000) {
            return PIXEL_CACHE[value];
        }
        return new PixelMeasure(value);
    }

    public int getPixel() {
        return this.pixel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelMeasure that = (PixelMeasure)o;
        return this.pixel == that.pixel;
    }

    public int hashCode() {
        return this.pixel;
    }

    static {
        for (int i = 0; i < PIXEL_CACHE.length; ++i) {
            PixelMeasure.PIXEL_CACHE[i] = new PixelMeasure(i);
        }
    }
}

