/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.myfaces.tobago.internal.util.StringUtils;

public final class ColumnPartition
implements Serializable {
    private static final Integer[] INTEGER_12 = new Integer[]{12};
    public static final ColumnPartition PARTITION_12 = new ColumnPartition(INTEGER_12);
    private Integer[] parts;

    public ColumnPartition() {
        this(new Integer[0]);
    }

    public ColumnPartition(Integer ... parts) {
        this.setParts(parts);
    }

    public static ColumnPartition valueOf(String string) {
        List<Integer> integers = StringUtils.parseIntegerList(string, ";");
        return new ColumnPartition(integers.toArray(new Integer[integers.size()]));
    }

    public static ColumnPartition valueOf(Object object) {
        if (object instanceof String) {
            return ColumnPartition.valueOf((String)object);
        }
        if (object instanceof Integer[]) {
            return new ColumnPartition((Integer[])object);
        }
        if (object != null) {
            return ColumnPartition.valueOf(object.toString());
        }
        return PARTITION_12;
    }

    private boolean checkSum(Integer[] summands) {
        if (summands == null || summands.length == 0) {
            return false;
        }
        int sum = 0;
        Integer[] integerArray = summands;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int summand = integerArray[i];
            if (summand < 1) {
                return false;
            }
            if ((sum += summand) <= 12) continue;
            return false;
        }
        return sum == 12;
    }

    private Integer[] createParts(Integer[] summands) {
        return this.createParts(Arrays.asList(summands));
    }

    private Integer[] createParts(List<Integer> summands) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (summands == null || summands.size() == 0) {
            return INTEGER_12;
        }
        int sum = 0;
        for (int summand : summands) {
            if (summand < 1) {
                summand = 1;
            }
            if (sum + summand > 12) break;
            sum += summand;
            list.add(summand);
        }
        if (sum < 12) {
            list.add(12 - sum);
        }
        return list.toArray(new Integer[list.size()]);
    }

    public Integer[] getParts() {
        return this.parts;
    }

    private void setParts(Integer[] parts) {
        this.parts = this.checkSum(parts) ? parts : this.createParts(parts);
    }

    public int getSize() {
        return this.parts.length;
    }

    public int getPart(int column) {
        return this.parts[column];
    }

    public String toString() {
        return Arrays.toString((Object[])this.parts);
    }
}

